/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.guava;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.service.IHZSerializer;
import com.horizon.cache.api.service.serializers.HObjectSerializer;
import com.horizon.common.cache.Cache;

public class HGuavaCache
implements IHCache {
    private static IHZSerializer<Object> serializer = new HObjectSerializer();
    private String name;
    private Cache<String, Object> cache;

    public HGuavaCache(String name, Cache<String, Object> cache) {
        this.name = name;
        this.cache = cache;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(String key) {
        Object value = this.cache.getIfPresent((Object)key);
        return serializer.deserialize(value);
    }

    @Override
    public void put(String key, Object value, Long timeout) {
        this.cache.put((Object)key, serializer.serialize(value));
    }

    @Override
    public boolean exist(String key) {
        return this.cache.getIfPresent((Object)key) != null;
    }

    @Override
    public void evict(String key) {
        try {
            this.cache.invalidate((Object)key);
        }
        catch (Exception e) {
            throw new HCacheException(e);
        }
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    public static IHZSerializer<Object> getSerializer() {
        return serializer;
    }

    public static void setSerializer(IHZSerializer<Object> serializer) {
        HGuavaCache.serializer = serializer;
    }
}

