/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.ehcache;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.modules.ehcache.HEhCache;
import com.horizon.cache.api.service.HCacheProperties;
import com.horizon.profile.AppConfig;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;

public class HEhCacheManager
implements IHCacheManager {
    private static final String profile = "cache";
    private CacheManager manager = null;
    private HCacheProperties properties;

    public HEhCacheManager(HCacheProperties properties) {
        this.properties = properties;
    }

    public HEhCacheManager() {
        this.properties = new HCacheProperties(AppConfig.getProfile(profile));
    }

    @Override
    public IHCache getCache(String cacheName, Long timeout) {
        Cache cache = this.manager.getCache(cacheName);
        if (cache == null) {
            int maxElementsInMemory = this.properties.getInteger("ehcache.maxElementsInMemory");
            boolean bool = timeout == null || timeout == 0L;
            CacheConfiguration config = new CacheConfiguration(cacheName, maxElementsInMemory).overflowToDisk(this.properties.getBoolean("ehcache.overflowToDisk").booleanValue()).eternal(this.properties.getBoolean("ehcache.eternal").booleanValue()).timeToLiveSeconds(bool ? (long)this.properties.getInteger("ehcache.timeToLiveSeconds").intValue() : timeout).timeToIdleSeconds(bool ? (long)this.properties.getInteger("ehcache.timeToIdleSeconds").intValue() : timeout).diskPersistent(false).diskExpiryThreadIntervalSeconds((long)this.properties.getInteger("ehcahce.diskExpiryThreadIntervalSeconds").intValue());
            cache = new Cache(config);
            this.manager.addCache(cache);
        }
        return new HEhCache(cacheName, cache);
    }

    @Override
    public String getType() {
        return "ehcache";
    }

    @Override
    public void init() throws HCacheException {
        this.manager = CacheManager.create();
    }

    @Override
    public void destory() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
            this.properties = null;
        }
    }
}

