/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.ehcache;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.service.IHZSerializer;
import com.horizon.cache.api.service.serializers.HJsonSerializer;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class HEhCache
implements IHCache {
    private static IHZSerializer<String> serializer = new HJsonSerializer();
    private String name;
    private Cache cache;

    public HEhCache(String cacheName, Cache cache) {
        this.name = cacheName;
        this.cache = cache;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        return null != element ? serializer.deserialize((String)element.getObjectValue()) : null;
    }

    @Override
    public void put(String key, Object value, Long timeout) {
        Element element = new Element((Serializable)((Object)key), (Serializable)((Object)serializer.serialize(value)));
        this.cache.put(element);
    }

    @Override
    public boolean exist(String key) {
        return this.cache.get((Serializable)((Object)key)) != null;
    }

    @Override
    public void evict(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    public static IHZSerializer<String> getSerializer() {
        return serializer;
    }

    public static void setSerializer(IHZSerializer<String> serializer) {
        HEhCache.serializer = serializer;
    }
}

