/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api;

import com.horizon.cache.api.HCacheManagerFactory;
import com.horizon.cache.api.IHCache;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;

public class HTenantCacheClient {
    private static IHCache getCache(String cacheName) {
        return HCacheManagerFactory.getCache(cacheName);
    }

    private static IHCache getCache(String cacheName, Long timeout) {
        return HCacheManagerFactory.getCache(cacheName, timeout);
    }

    public static <T> T get(String tenantCode, String cacheName, String key) {
        IHCache cache = HTenantCacheClient.getCache(HTenantCacheClient.formatCacheName(tenantCode, cacheName));
        if (cache == null) {
            return null;
        }
        return (T)cache.get(key);
    }

    public static void put(String tenantCode, String cacheName, String key, Object value, Long timeout) {
        IHCache cache = HTenantCacheClient.getCache(HTenantCacheClient.formatCacheName(tenantCode, cacheName), timeout);
        if (cache == null) {
            return;
        }
        cache.put(key, value, timeout);
    }

    public static boolean keyExists(String tenantCode, String cacheName, String key) {
        IHCache cache = HTenantCacheClient.getCache(HTenantCacheClient.formatCacheName(tenantCode, cacheName));
        if (cache == null) {
            return false;
        }
        return cache.exist(key);
    }

    public static void clear(String tenantCode, String cacheName) {
        IHCache cache = HTenantCacheClient.getCache(HTenantCacheClient.formatCacheName(tenantCode, cacheName));
        if (cache == null) {
            return;
        }
        cache.clear();
    }

    public static void remove(String tenantCode, String cacheName, String key) {
        IHCache cache = HTenantCacheClient.getCache(HTenantCacheClient.formatCacheName(tenantCode, cacheName));
        if (cache == null) {
            return;
        }
        cache.evict(key);
    }

    private static String formatCacheName(String tenantCode, String cacheName) {
        if (!StringUtil.hasValue(cacheName)) {
            cacheName = AppConfig.get("cache", "default.cache.name");
        }
        tenantCode = StringUtil.hasValue(tenantCode) ? tenantCode : "system";
        return tenantCode.toUpperCase() + ":" + cacheName;
    }
}

