/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.modules.local.HLocalCacheManager;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Maps;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HCacheManagerFactory {
    private static Map<String, IHCacheManager> managerPool = Maps.newLinkedHashMap();
    private static Map<String, HashMap<String, IHCache>> cachePool = Maps.newHashMap();

    public static void regiestCacheManager(IHCacheManager horizonCacheManager) throws HCacheException {
        if (horizonCacheManager != null && StringUtil.hasValue(horizonCacheManager.getType())) {
            String type = horizonCacheManager.getType();
            HCacheManagerFactory.removeCacheManger(type);
            horizonCacheManager.init();
            managerPool.put(type, horizonCacheManager);
        }
    }

    public static void addCacheManager(IHCacheManager horizonCacheManager) {
        if (horizonCacheManager != null && StringUtil.hasValue(horizonCacheManager.getType())) {
            String type = horizonCacheManager.getType();
            HCacheManagerFactory.removeCacheManger(type);
            managerPool.put(type, horizonCacheManager);
        }
    }

    public static void removeCacheManger(String type) {
        IHCacheManager manager = managerPool.get(type);
        if (manager != null) {
            manager.destory();
            managerPool.remove(type);
            cachePool.clear();
        }
    }

    public static void clearCachePool() {
        cachePool.clear();
    }

    public static Set<String> currentTypes() {
        return managerPool.keySet();
    }

    public static IHCache getCache(String cacheName) {
        String type = AppConfig.get("cache", "cache.type");
        HashMap<String, IHCache> map = cachePool.get(type);
        if (map == null) {
            return null;
        }
        return map.get(cacheName);
    }

    public static IHCache getCache(String cacheName, Long timeout) {
        String type = AppConfig.get("cache", "cache.type");
        return HCacheManagerFactory.getCache(type, cacheName, timeout);
    }

    public static IHCache getCache(String type, String cacheName, Long timeout) {
        HashMap map = cachePool.get(type);
        IHCache cache = null;
        if (map == null) {
            cache = HCacheManagerFactory.getCacheFromNative(type, cacheName, timeout);
            if (cache != null) {
                map = Maps.newHashMap();
                map.put(cacheName, cache);
                cachePool.put(type, map);
            }
        } else {
            cache = map.get(cacheName);
            if (cache == null && (cache = HCacheManagerFactory.getCacheFromNative(type, cacheName, timeout)) != null) {
                map.put(cacheName, cache);
            }
        }
        return cache;
    }

    public static IHCache getCacheByType(String type, String cacheName, Long timeout) {
        IHCacheManager cacheManager = HCacheManagerFactory.get(type);
        if (cacheManager == null) {
            return null;
        }
        return cacheManager.getCache(cacheName, timeout);
    }

    private static IHCache getCacheFromNative(String type, String cacheName, Long timeout) {
        IHCache cache = HCacheManagerFactory.getCacheByType(type, cacheName, timeout);
        String enableLocalCache = AppConfig.get("cache", "enableLocalCache");
        if (Objects.equal((Object)"true", (Object)enableLocalCache)) {
            cache = HLocalCacheManager.getCache(cache);
        }
        return cache;
    }

    public static IHCacheManager get(String type) {
        IHCacheManager manager = managerPool.get(type);
        if (manager != null) {
            return manager;
        }
        return HCacheManagerFactory.get();
    }

    private static IHCacheManager get() {
        String defaultCacheManager = AppConfig.get("cache", "cache.type");
        if (StringUtil.hasValue(defaultCacheManager)) {
            IHCacheManager manager = managerPool.get(defaultCacheManager);
            return manager;
        }
        return null;
    }
}

