/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api;

import com.horizon.cache.api.HCacheManagerFactory;
import com.horizon.cache.api.IHCache;
import com.horizon.core.HorizonCore;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;

public class HCacheClient {
    private static IHCache getCache(String cacheName) {
        return HCacheManagerFactory.getCache(cacheName);
    }

    private static IHCache getCache(String cacheName, Long timeout) {
        return HCacheManagerFactory.getCache(cacheName, timeout);
    }

    public static <T> T get(String cacheName, String key) {
        IHCache cache = HCacheClient.getCache(HCacheClient.formatCacheName(cacheName));
        if (cache == null) {
            return null;
        }
        return (T)cache.get(key);
    }

    public static void put(String cacheName, String key, Object value, Long timeout) {
        IHCache cache = HCacheClient.getCache(HCacheClient.formatCacheName(cacheName), timeout);
        if (cache == null) {
            return;
        }
        cache.put(key, value, timeout);
    }

    public static <T> T get(String key) {
        return HCacheClient.get(null, key);
    }

    public static void put(String key, Object value, Long timeout) {
        HCacheClient.put(null, key, value, timeout);
    }

    public static void put(String key, Object value) {
        HCacheClient.put(null, key, value, null);
    }

    public static boolean keyExists(String cacheName, String key) {
        IHCache cache = HCacheClient.getCache(HCacheClient.formatCacheName(cacheName));
        if (cache == null) {
            return false;
        }
        return cache.exist(key);
    }

    public static boolean keyExists(String key) {
        return HCacheClient.keyExists(null, key);
    }

    public static void clear(String cacheName) {
        IHCache cache = HCacheClient.getCache(HCacheClient.formatCacheName(cacheName));
        if (cache == null) {
            return;
        }
        cache.clear();
    }

    public static void clear() {
        HCacheClient.clear(null);
    }

    public static void remove(String cacheName, String key) {
        IHCache cache = HCacheClient.getCache(HCacheClient.formatCacheName(cacheName));
        if (cache == null) {
            return;
        }
        cache.evict(key);
    }

    public static void remove(String key) {
        HCacheClient.remove(null, key);
    }

    private static String formatCacheName(String cacheName) {
        String code;
        if (!StringUtil.hasValue(cacheName)) {
            cacheName = AppConfig.get("cache", "default.cache.name");
        }
        code = StringUtil.hasValue(code = HorizonCore.TENANT_CODE.value()) ? code : "system";
        return code.toUpperCase() + ":" + cacheName;
    }
}

