/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache;

import com.horizon.cache.api.HCacheManagerFactory;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.modules.ehcache.HEhCacheManager;
import com.horizon.cache.api.modules.guava.HGuavaCacheManager;
import com.horizon.cache.api.modules.memcache.HMemcacheCacheManager;
import com.horizon.cache.api.modules.redis.HRedisCacheManager;
import com.horizon.cache.api.service.HCacheProperties;
import com.horizon.common.base.Objects;
import com.horizon.utils.StringUtil;
import java.util.Map;

public enum CacheType {
    GUAVA("guava"){

        @Override
        public IHCacheManager cacheManager(Map map) {
            HGuavaCacheManager manager = new HGuavaCacheManager(new HCacheProperties(map));
            manager.init();
            return manager;
        }
    }
    ,
    REDIS("redis"){

        @Override
        public IHCacheManager cacheManager(Map map) {
            HRedisCacheManager manager = new HRedisCacheManager(new HCacheProperties(map));
            manager.init();
            return manager;
        }
    }
    ,
    MEMCACHE("memcache"){

        @Override
        public IHCacheManager cacheManager(Map map) {
            HMemcacheCacheManager manager = new HMemcacheCacheManager(new HCacheProperties(map));
            manager.init();
            return manager;
        }
    }
    ,
    EHCACHE("ehcache"){

        @Override
        public IHCacheManager cacheManager(Map map) {
            HEhCacheManager manager = new HEhCacheManager(new HCacheProperties(map));
            manager.init();
            return manager;
        }
    };

    private String type;

    public void doWithManager(Map map) {
        boolean enable = this.getEnable(this.getType() + ".enable", map);
        if (enable) {
            IHCacheManager manager = this.cacheManager(map);
            HCacheManagerFactory.addCacheManager(manager);
        } else {
            HCacheManagerFactory.removeCacheManger(this.getType());
        }
    }

    protected abstract IHCacheManager cacheManager(Map var1);

    protected boolean getEnable(String enableName, Map map) {
        String enable = (String)map.get(enableName);
        if (!StringUtil.hasValue(enable)) {
            throw new HCacheException("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570");
        }
        return Boolean.parseBoolean(enable);
    }

    public static CacheType getCacheByType(String type) {
        if (!StringUtil.hasValue(type)) {
            return null;
        }
        for (CacheType cacheType : CacheType.values()) {
            if (!Objects.equal((Object)cacheType.getType(), (Object)type)) continue;
            return cacheType;
        }
        return null;
    }

    private CacheType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}

