/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.workflow.chart.web;

import com.horizon.common.collect.ArrayListMultimap;
import com.horizon.core.common.controller.SuperController;
import com.horizon.core.context.Context;
import com.horizon.core.context.ContextFactory;
import com.horizon.utils.StringUtil;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.definition.FlowDefinitionUtil;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.definition.api.XMLFlowInfo;
import com.horizon.wf.tools.JSONUtil;
import com.horizon.workflow.designer.wf.WorkFlow;
import com.horizon.workflow.designer.wf.vo.InstanceNumVO;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSON;
import net.sf.json.xml.XMLSerializer;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Controller
@RequestMapping(value={"${url.prefix}/flowchart"})
public class FlowChartController
extends SuperController {
    @RequestMapping(value={"/data${url.suffix}"})
    @ResponseBody
    public String data() {
        String flowId = this.req.getParameter("flowId");
        String workId = this.req.getParameter("workId");
        String tenantCode = this.req.getParameter("tenantCode");
        String identifier = this.req.getParameter("identifier");
        String defaultCode = "system";
        String rs = "";
        String historys = "";
        String instanceNums = "";
        try {
            Context context = ContextFactory.INSTANCE.getContext();
            if (!StringUtil.hasValue((String)tenantCode) && !StringUtil.hasValue((String)(tenantCode = context.getTenantCode()))) {
                tenantCode = defaultCode;
            }
            if (!StringUtil.hasValue((String)identifier) && !StringUtil.hasValue((String)(identifier = context.getTenantIdentifier()))) {
                identifier = defaultCode;
            }
            if (StringUtil.hasValue((String)workId)) {
                rs = XmlDBUtil.getMapXMLString((String)workId, (String)tenantCode, (String)identifier);
                historys = this.getHistory(workId, identifier);
            } else if (StringUtil.hasValue((String)flowId)) {
                WorkFlow workFlow;
                List instanceNumVOList;
                FlowDefinitionUtil flow = new FlowDefinitionUtil("", "");
                XMLFlowInfo f = flow.getFlow(flowId, null, identifier);
                rs = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><FlowMap>" + f.getMapXML();
                String instanceNum = this.req.getParameter("instanceNum");
                if (StringUtil.hasValue((String)instanceNum) && instanceNum.equals("true") && null != (instanceNumVOList = (workFlow = new WorkFlow()).getFlowInstanceNum(flowId, identifier)) && !instanceNumVOList.isEmpty()) {
                    ArrayListMultimap listMultimap = ArrayListMultimap.create();
                    Iterator iterator = instanceNumVOList.iterator();
                    while (iterator.hasNext()) {
                        InstanceNumVO instanceNumVO = (InstanceNumVO)iterator.next();
                        String nodeId = instanceNumVO.getNodeid();
                        if (!listMultimap.isEmpty() && listMultimap.get((Object)nodeId).size() > 0) {
                            InstanceNumVO instanceNumVO1 = (InstanceNumVO)listMultimap.get((Object)nodeId).get(0);
                            int sum = instanceNumVO1.getSumnum();
                            instanceNumVO1.setSumnum(sum += instanceNumVO.getSumnum());
                            iterator.remove();
                            continue;
                        }
                        listMultimap.put((Object)nodeId, (Object)instanceNumVO);
                    }
                    instanceNums = JSONUtil.toJson((Object)instanceNumVOList);
                    if (StringUtil.hasValue((String)instanceNums)) {
                        rs = rs + "<Map><InstanceNums/></Map>";
                    }
                }
                rs = rs + "<OrgName>" + flow.getOrgName() + "</OrgName>";
                rs = rs + "</FlowMap>";
            }
            XMLSerializer xmlSerializer = new XMLSerializer();
            xmlSerializer.setTypeHintsEnabled(false);
            JSON json = xmlSerializer.read(rs);
            rs = json.toString().replace("@", "");
            rs = rs.replace("\"OrgName\":[]", "\"OrgName\":\"\"");
            if (StringUtil.hasValue((String)historys)) {
                rs = rs.replace("\"Historys\":[]", "\"Historys\":" + historys);
            }
            if (StringUtil.hasValue((String)instanceNums)) {
                rs = rs.replace("\"InstanceNums\":[]", "\"InstanceNums\":" + instanceNums);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BASE64Encoder base64Encoder = new BASE64Encoder();
        try {
            rs = base64Encoder.encodeBuffer(base64Encoder.encodeBuffer(URLEncoder.encode(rs, "UTF-8").replaceAll("\\+", " ").getBytes()).getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "{\"code\": 0, \"status\": \"success\",\"data\": \"" + rs.replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "") + "\", \"msg\": \"\u8bf7\u6c42\u6210\u529f\"}";
    }

    @RequestMapping(value={"/download${url.suffix}"})
    public void download(HttpServletResponse response) {
        String imageName = this.req.getParameter("imageName");
        String imageData = this.req.getParameter("imageData");
        imageData = imageData.split("base64,")[1];
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] decoderByte = decoder.decodeBuffer(imageData);
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-disposition", "attachment;" + this.encodeFileName(imageName));
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            out.write(decoderByte);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getHistory(String workId, String identifier) {
        IWorkflowOperator ica = WorkflowFactory.getWorkFlowOperator();
        List logs = ica.getHistory(workId, identifier);
        String jsonLog = null;
        if (logs != null && !logs.isEmpty()) {
            jsonLog = JSONUtil.toJson((Object)logs);
        }
        return jsonLog;
    }

    private String encodeFileName(String fileName) {
        String userAgent = this.req.getHeader("User-Agent");
        String eFileName = "";
        try {
            String newFileName = URLEncoder.encode(fileName, "utf-8");
            eFileName = StringUtil.hasValue((String)userAgent) ? ((userAgent = userAgent.toLowerCase()).contains("opera") ? "filename*=UTF-8''" + newFileName : (userAgent.contains("safari") ? "filename=\"" + new String(fileName.getBytes("UTF-8"), "ISO8859-1") + "\"" : (userAgent.contains("mozilla") ? "filename*=UTF-8''" + newFileName : "filename=\"" + newFileName + "\""))) : "filename=\"" + newFileName + "\"";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return eFileName;
    }
}

