-- drop table   SYS_BUTTON  ;
create table SYS_BUTTON
(
  id          VARCHAR2(32) not null,
  button_name VARCHAR2(50),
  button_size VARCHAR2(32),
  button_type VARCHAR2(32),
  plain       NUMBER(1),
  round       NUMBER(1),
  circle      NUMBER(1),
  loading     NUMBER(1),
  disabled    NUMBER(1),
  icon        VARCHAR2(32),
  autofocus   NUMBER(1),
  click       VARCHAR2(200),
  sort        NUMBER(9)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_BUTTON
  add constraint SYS_BUTTON_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
