-- drop table LOG_FUNCTION;
create table LOG_FUNCTION
(
  id         VARCHAR2(32) not null,
  request_id VARCHAR2(32),
  start_time TIMESTAMP(6),
  end_time   TIMESTAMP(6),
  duration   NUMBER(10),
  params     VARCHAR2(500),
  class_name VARCHAR2(500),
  log_id     VARCHAR2(50)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;

alter table LOG_FUNCTION
  add constraint LOG_FUNCTION_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
