package ${package.ServiceImpl};

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.shinsoft.tools.model.system.TablePersonal;
import com.shinsoft.tools.ExcelTools.ExportExcelTools;

import com.shinsoft.activitiapi.model.ProcessStartResult;
import com.shinsoft.activitiapi.service.ActivitiService;
import com.shinsoft.frameworkapi.service.FrameworkService;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResultJSON;
import com.shinsoft.tools.model.system.SysUser;
import com.shinsoft.frameworkapi.model.SysDepartment;

import ${package.Mapper}.${table.mapperName};
import ${package.Entity}.${table.entityName};
import ${package.Service}.${table.serviceName};

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.io.OutputStream;
import java.util.*;

@Service("${table.entityName}Service")
public class ${table.entityName}ServiceImpl implements ${table.entityName}Service {

        @Autowired
        ActivitiService activitiService;

        @Autowired
        FrameworkService frameworkService;

        @Autowired
        ${table.entityName}Mapper ${table.entityPath}Mapper;

        ResultJSON resultJSON;

@Override
public ResultJSON queryPopup(String userId, String menuId, String belongId, int page, int rows<#if cfg.querys?? && (cfg.querys?size > 0) >, </#if>
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName>
            <#if query.controllerType =='日期' >
                ${field.propertyType} ${field.propertyName}Begin,
                ${field.propertyType} ${field.propertyName}End<#sep>,</#sep>
            <#elseif query.controllerType =='日期时间' >
                ${field.propertyType} ${field.propertyName}Begin,
                ${field.propertyType} ${field.propertyName}End<#sep>,</#sep>
            <#else>
                ${field.propertyType} ${field.propertyName}<#sep>,</#sep>
            </#if>
        </#if>
    </#list>
</#list>) {

        PageHelper.startPage(page, rows);
        Map<#noparse><</#noparse><#noparse>String</#noparse><#noparse>,</#noparse>Object> map = new HashMap<>();
        map.put("belongId",belongId);
        <#list table.fields as field>
        <#list cfg.querys as query>
        <#if field.name == query.fieldName>
        <#if query.controllerType =='日期' >
        map.put("${field.propertyName}Begin",${field.propertyName}Begin);
        map.put("${field.propertyName}End",${field.propertyName}End);
        <#elseif query.controllerType =='日期时间' >
        map.put("${field.propertyName}Begin",${field.propertyName}Begin);
        map.put("${field.propertyName}End",${field.propertyName}End);
        <#else>
        map.put("${field.propertyName}",${field.propertyName});
        </#if>
        </#if>
        </#list>
        </#list>
        List<${table.entityName}> list = ${table.entityPath}Mapper.selectForPopup(map);
        PageInfo<${table.entityName}> pageInfo = new PageInfo<>(list);
        resultJSON = JSONTools.toResultJSON(pageInfo);
        return resultJSON;
        }

            @Override
            public ResultJSON queryPage(String userId, String menuId, String belongId, int page, int rows<#if cfg.querys?? && (cfg.querys?size > 0) >, </#if>
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName>
            <#if query.controllerType =='日期' >
                ${field.propertyType} ${field.propertyName}Begin,
                ${field.propertyType} ${field.propertyName}End<#sep>,</#sep>
            <#elseif query.controllerType =='日期时间' >
                ${field.propertyType} ${field.propertyName}Begin,
                ${field.propertyType} ${field.propertyName}End<#sep>,</#sep>
            <#else>
                ${field.propertyType} ${field.propertyName}<#sep>,</#sep>
            </#if>
        </#if>
    </#list>
</#list>) {
                ResultJSON re = frameworkService.queryDataPermission(userId, menuId);
                Map<String<#noparse>,</#noparse> Object> mapPermission = JSONTools.objectToModel(re.getData(), Map.class);
                String personalFlag = mapPermission.get("personalFlag").toString();
                List<SysDepartment> departmentList = JSONTools.objectToList(mapPermission.get("departmentList"), SysDepartment.class);
                List<String> departmentCodeList = JSONTools.objectToList(mapPermission.get("departmentCodeList"), String.class);
                PageHelper.startPage(page, rows);
                Map<#noparse><</#noparse><#noparse>String</#noparse><#noparse>,</#noparse>Object> map = new HashMap<>();
                map.put("belongId",belongId);
                map.put("userId", userId);
                map.put("departmentCodeList", departmentCodeList);
                map.put("personalFlag", personalFlag);

                <#list table.fields as field>
                    <#list cfg.querys as query>
                        <#if field.name == query.fieldName>
                            <#if query.controllerType =='日期' >
                map.put("${field.propertyName}Begin",${field.propertyName}Begin);
                map.put("${field.propertyName}End",${field.propertyName}End);
                            <#elseif query.controllerType =='日期时间' >
                map.put("${field.propertyName}Begin",${field.propertyName}Begin);
                map.put("${field.propertyName}End",${field.propertyName}End);
                            <#else>
                map.put("${field.propertyName}",${field.propertyName});
                            </#if>
                        </#if>
                    </#list>
                </#list>
                List<${table.entityName}> list = ${table.entityPath}Mapper.selectByParam(map);
                PageInfo<${table.entityName}> pageInfo = new PageInfo<>(list);
                resultJSON = JSONTools.toResultJSON(pageInfo);
                return resultJSON;
            }



            @Override
            public ResultJSON queryByPK(String userId, String menuId, String belongId, String id) {
                ${table.entityName} record = ${table.entityPath}Mapper.selectByPrimaryKey(id);
                resultJSON = JSONTools.toResultJSON(record);
                return resultJSON;
            }

            @Override
            public ResultJSON save(String userId, String menuId, String belongId, String json) {
                Date date = new Date();
                ${table.entityName} record = JSON.parseObject(json,new TypeReference<${table.entityName}>(){});
                ResultJSON resultJSONUser =  frameworkService.queryUserById(userId) ;
                SysUser user = JSONTools.objectToModel(resultJSONUser.getData(),SysUser.class);
                if(StringUtils.isEmpty(record.getId())){
                record.setAddId(userId);
                record.setAddCode(user.getUserCode());
                record.setAddName(user.getUserDesc());
                record.setAddTime(date);
                record.setCancelFlag("0");
                record.setBelongId(belongId);
                ${table.entityPath}Mapper.insert(record);
                }else {
                record.setModifyId(userId);
                record.setModifyCode(user.getUserCode());
                record.setModifyName(user.getUserDesc());
                record.setModifyTime(date);
                ${table.entityPath}Mapper.updateByPrimaryKey(record);
                }
                resultJSON = JSONTools.toResultJSON(record);
                return resultJSON;
                }

            @Override
            public ResultJSON remove(String userId, String menuId, String belongId, String id) {
                ResultJSON resultJSON =  frameworkService.queryUserById(userId) ;
                SysUser user = JSONTools.objectToModel(resultJSON.getData(),SysUser.class);
                ${table.entityName} record = ${table.entityPath}Mapper.selectByPrimaryKey(id);
                record.setCancelFlag("1");
                record.setCancelId(userId);
                record.setCancelCode(user.getUserCode());
                record.setCancelName(user.getUserDesc());
                record.setCancelTime(new Date());
                ${table.entityPath}Mapper.updateByPrimaryKey(record);
                resultJSON = JSONTools.toResultJSON(record);
                return resultJSON;
            }

            @Override
            public ResultJSON removeBatch(String userId, String menuId, String belongId, String[] ids) {
                ResultJSON resultJSON =  frameworkService.queryUserById(userId) ;
                SysUser user = JSONTools.objectToModel(resultJSON.getData(),SysUser.class);
                ${table.entityName} record;
                for (String id:ids ) {
                record = ${table.entityPath}Mapper.selectByPrimaryKey(id);
                record.setCancelFlag("1");
                record.setCancelId(userId);
                record.setCancelCode(user.getUserCode());
                record.setCancelName(user.getUserDesc());
                record.setCancelTime(new Date());
                ${table.entityPath}Mapper.updateByPrimaryKey(record);
                }
                resultJSON = JSONTools.toResultJSON(ids);
                return resultJSON;
            }

            @Override
            public ResultJSON start(String userId, String menuId, String belongId, String id) {
                ${table.entityName} record = ${table.entityPath}Mapper.selectByPrimaryKey(id);
                Map<String<#noparse>,</#noparse>Object> map = new HashMap();
                map.put("businessId", id);
                map.put("userId", userId);
                map.put("processKey", "${cfg.processKey}");
                map.put("tableName", "${table.name}");
                ResultJSON result;
                result = activitiService.start(JSON.toJSONString(map));
                if (result.getCode() == 0) {
                    ProcessStartResult processStartResult = JSONTools.toModel(result.getData(), ProcessStartResult.class);
                    resultJSON = JSONTools.toResultJSON(processStartResult);
                } else {
                    resultJSON = JSONTools.toResultJSON(result.getCode(), result.getMsg());
                }
                return resultJSON;
            }


  @Override
    public void export(HttpServletResponse response,String userId, String menuId, String belongId, String tName<#if cfg.querys?? && (cfg.querys?size > 0) >, </#if>
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName>
            <#if query.controllerType =='日期' >
                ${field.propertyType} ${field.propertyName}Begin,
                ${field.propertyType} ${field.propertyName}End<#sep>,</#sep>
            <#elseif query.controllerType =='日期时间' >
                ${field.propertyType} ${field.propertyName}Begin,
                ${field.propertyType} ${field.propertyName}End<#sep>,</#sep>
            <#else>
                ${field.propertyType} ${field.propertyName}<#sep>,</#sep>
            </#if>
        </#if>
    </#list>
</#list>) {
        ResultJSON re = frameworkService.queryDataPermission(userId, menuId);
        Map<String<#noparse>,</#noparse> Object> mapPermission = JSONTools.objectToModel(re.getData(), Map.class);
        String personalFlag = mapPermission.get("personalFlag").toString();
        List<SysDepartment> departmentList = JSONTools.objectToList(mapPermission.get("departmentList"), SysDepartment.class);
        List<String> departmentCodeList = JSONTools.objectToList(mapPermission.get("departmentCodeList"), String.class);
        Map<String<#noparse>,</#noparse>Object> map = new HashMap<>();
        map.put("belongId",belongId);
        map.put("userId", userId);
        map.put("departmentCodeList", departmentCodeList);
        map.put("personalFlag", personalFlag);
         <#list table.fields as field>
                    <#list cfg.querys as query>
                        <#if field.name == query.fieldName>
                            <#if query.controllerType =='日期' >
                map.put("${field.propertyName}Begin",${field.propertyName}Begin);
                map.put("${field.propertyName}End",${field.propertyName}End);
                            <#elseif query.controllerType =='日期时间' >
                map.put("${field.propertyName}Begin",${field.propertyName}Begin);
                map.put("${field.propertyName}End",${field.propertyName}End);
                            <#else>
                map.put("${field.propertyName}",${field.propertyName});
                            </#if>
                        </#if>
                    </#list>
                </#list>
        List<${table.entityName}> list = ${table.entityPath}Mapper.selectByParam(map);

        ResultJSON retp =   frameworkService.queryTablePersonalByUserIdMenuId(userId,menuId,tName);
        List<TablePersonal> listTablePersonal = JSONTools.objectToList(retp.getData(), TablePersonal.class);
        List<String> headers = new ArrayList<>();
        List<String> columns = new ArrayList<>();
        List<Integer> widths = new ArrayList<>();
        for(TablePersonal tablePersonal:listTablePersonal){
            if(tablePersonal.getExportFlag().equals("1")){
                headers.add(tablePersonal.getLabel());
                columns.add(tablePersonal.getProp());
                widths.add(Integer.parseInt(tablePersonal.getWidth()));
            }
        }
        OutputStream out = ExportExcelTools.getExportOutStream("导出.xlsx", response);
        List<Map<#noparse><</#noparse>String<#noparse>,</#noparse> Object>> listmap =   ExportExcelTools.getExportData(columns,list);
        ExportExcelTools<List<#noparse><</#noparse>Map<#noparse><</#noparse>String<#noparse>,</#noparse> Object>>> exportExcel = new ExportExcelTools<List<#noparse><</#noparse>Map<#noparse><</#noparse>String<#noparse>,</#noparse> Object>>>();
        exportExcel.exportXSExcelByColumn("Title", headers, columns, widths,listmap, out, null);
    }

}