-- drop table     ;
create table SYS_TOKEN
(
  token       VARCHAR2(2000) not null,
  add_id      VARCHAR2(32) not null,
  add_time    DATE,
  public_key  VARCHAR2(2000),
  private_key VARCHAR2(2000),
  life_flag   VARCHAR2(1),
  memo        VARCHAR2(500),
  id          VARCHAR2(32) not null,
  os          VARCHAR2(32)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_TOKEN.public_key
  is '公钥';
comment on column SYS_TOKEN.private_key
  is '私钥';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_TOKEN
  add constraint SYS_TOKEN_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
