-- drop table     ;
create table SYS_MENU
(
  id             VARCHAR2(200) not null,
  menu_pid       VARCHAR2(20),
  menu_code      VARCHAR2(50),
  menu_name      VARCHAR2(100),
  menu_open_cs   VARCHAR2(100),
  menu_open_bs   VARCHAR2(100),
  menu_open_ios  VARCHAR2(100),
  menu_open_and  VARCHAR2(100),
  menu_app       NUMBER(1),
  menu_app_order NUMBER(5),
  menu_app_img   VARCHAR2(200),
  add_id         VARCHAR2(200),
  add_time       DATE,
  modify_id      VARCHAR2(200),
  modify_time    DATE,
  cancel_id      VARCHAR2(200),
  cancel_time    DATE,
  cancel_flag    VARCHAR2(1),
  top_code       VARCHAR2(50),
  menu_bs_icon   VARCHAR2(100),
  menu_show      NUMBER(1),
  menu_query     NUMBER(1),
  menu_app_icon  VARCHAR2(100)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_MENU.cancel_flag
  is '0存在9不存在';
comment on column SYS_MENU.menu_show
  is '0显示 9不显示';
comment on column SYS_MENU.menu_query
  is '查询权限  0无1有';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_MENU
  add constraint SYS_MENU_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
