-- drop table     ;
create table LOG_REQUEST
(
  id               VARCHAR2(32) not null,
  url              VARCHAR2(100),
  method_type      VARCHAR2(10),
  encrypt_flag     VARCHAR2(1),
  public_key       VARCHAR2(500),
  key              VARCHAR2(100),
  iv               VARCHAR2(100),
  encrypt_params   VARCHAR2(500),
  params           VARCHAR2(2000),
  headers          VARCHAR2(500),
  token            VARCHAR2(500),
  response_code    VARCHAR2(50),
  token_message    VARCHAR2(500),
  add_id           VARCHAR2(32),
  add_time         DATE,
  belong_id        VARCHAR2(32),
  menu_id          VARCHAR2(32),
  os               VARCHAR2(32),
  response_message VARCHAR2(500),
  header_message   VARCHAR2(500),
  result_code      VARCHAR2(32),
  result_message   VARCHAR2(2000),
  log_id           VARCHAR2(50)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Create/Recreate primary, unique and foreign key constraints
alter table LOG_REQUEST
  add constraint LOG_REQUEST_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
