/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.shinsoft.tools.ExceptionTools;
import com.shinsoft.tools.model.common.Pages;
import com.shinsoft.tools.model.common.ResponseCodeMsg;
import com.shinsoft.tools.model.common.ResultJSON;
import java.util.List;

public class JSONTools {
    public static String toString(Object object) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
    }

    public static String toString(Object object, String format) {
        return JSON.toJSONStringWithDateFormat((Object)object, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
    }

    public static ResultJSON toResultJSON(int exCode, String exMessage, String fullMsg, Object object) {
        String str = JSONTools.toString(object);
        return new ResultJSON(exCode, exMessage, fullMsg, str);
    }

    public static ResultJSON toResultJSON(Object object) {
        return JSONTools.toResultJSON(ResponseCodeMsg.CODE_OK, ResponseCodeMsg.MSG_OK, ResponseCodeMsg.MSG_OK, object);
    }

    public static ResultJSON toResultJSON(int exCode, String exMessage) {
        return JSONTools.toResultJSON(exCode, exMessage, null, null);
    }

    public static ResultJSON toResultJSON(int exCode, String exMessage, String fullMsg) {
        return JSONTools.toResultJSON(exCode, exMessage, fullMsg, null);
    }

    public static ResultJSON toResultJSON(Exception ex) {
        return JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
    }

    public static ResultJSON toResultJSON(int code, Exception ex) {
        return JSONTools.toResultJSON(code, ex.getMessage(), ExceptionTools.getExceptionAllinformation(ex), null);
    }

    public static ResultJSON toResultJSON(Object object, String format) {
        String str = JSONTools.toString(object, format);
        return new ResultJSON(ResponseCodeMsg.CODE_OK, ResponseCodeMsg.MSG_OK, ResponseCodeMsg.MSG_OK, str);
    }

    public static String toResultString(int exCode, String exMessage, String fullMsg, Object object) {
        ResultJSON result = new ResultJSON(exCode, exMessage, fullMsg, object);
        return JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
    }

    public static String toResultString(Object object, String format) {
        ResultJSON result = new ResultJSON(ResponseCodeMsg.CODE_OK, ResponseCodeMsg.MSG_OK, object);
        return JSON.toJSONStringWithDateFormat((Object)result, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
    }

    public static String toResultString(Object object) {
        return JSONTools.toResultString(ResponseCodeMsg.CODE_OK, ResponseCodeMsg.MSG_OK, ResponseCodeMsg.MSG_OK, object);
    }

    public static String toResultString(int exCode, String exMessage) {
        return JSONTools.toResultString(exCode, exMessage, null, null);
    }

    public static String toResultString(int exCode, String exMessage, String fullMsg) {
        return JSONTools.toResultString(exCode, exMessage, fullMsg, null);
    }

    public static String toResultString(Exception ex) {
        return JSONTools.toResultString(ResponseCodeMsg.CODE_EX, ex);
    }

    public static String toResultString(int exCode, Exception ex) {
        return JSONTools.toResultString(exCode, ex.getMessage(), ExceptionTools.getExceptionAllinformation(ex), null);
    }

    public static String toResultJSONString(ResultJSON resultJSON) {
        return JSONTools.toString(resultJSON);
    }

    public static String toResultJSONString(ResultJSON resultJSON, String format) {
        return JSONTools.toString(resultJSON, format);
    }

    public static String getJSONValue(String key, JSONObject object) {
        return object.get((Object)key) == null ? "" : object.get((Object)key).toString();
    }

    public static <T> T objectToModel(Object object, Class<T> classT) {
        if (object instanceof String) {
            return (T)JSON.parseObject((String)object.toString(), classT);
        }
        return (T)JSON.parseObject((String)JSONTools.toString(object), classT);
    }

    public static <T> List<T> objectToList(Object object, Class<T> classT) {
        if (object instanceof String) {
            return JSON.parseArray((String)object.toString(), classT);
        }
        return JSON.parseArray((String)JSONTools.toString(object), classT);
    }

    public static <T> T toModel(Object object, Class<T> classT) {
        if (object instanceof String) {
            return (T)JSON.parseObject((String)object.toString(), classT);
        }
        return (T)JSON.parseObject((String)JSONTools.toString(object), classT);
    }

    public static <T> List<T> toList(Object object, Class<T> classT) {
        if (object instanceof String) {
            return JSON.parseArray((String)object.toString(), classT);
        }
        return JSON.parseArray((String)JSONTools.toString(object), classT);
    }

    public static Pages toPage(int total, Object object) {
        return new Pages(total, object);
    }
}

