/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools.ExcelTools;

import com.shinsoft.tools.ExcelTools.ExcelColumn;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ImportExcelTools {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0");
    private static final DecimalFormat DECIMAL_FORMAT_PERCENT = new DecimalFormat("##.00%");
    private static final FastDateFormat FAST_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy/MM/dd");
    private static final DecimalFormat DECIMAL_FORMAT_NUMBER = new DecimalFormat("0.00E000");
    private static final Pattern POINTS_PATTERN = Pattern.compile("0.0+_*[^/s]+");

    public static List<List<Object>> readExcel(MultipartFile file) throws IOException {
        String extension = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).toLowerCase();
        if (extension.endsWith("xls") || extension.endsWith("xlsx")) {
            return ImportExcelTools.readExcel(file.getInputStream());
        }
        throw new IOException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    public static <T> List<T> readExcel(MultipartFile file, Class<T> cls) throws IOException {
        String extension = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).toLowerCase();
        if (extension.endsWith("xls") || extension.endsWith("xlsx")) {
            return ImportExcelTools.readExcel(file.getInputStream(), cls);
        }
        throw new IOException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<Object>> readExcel(InputStream inputStream) throws IOException {
        LinkedList<List<Object>> list = new LinkedList<List<Object>>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            int sheetsNumber = workbook.getNumberOfSheets();
            for (int n = 0; n < sheetsNumber; ++n) {
                Sheet sheet = workbook.getSheetAt(n);
                Object value = null;
                Row row = null;
                Cell cell = null;
                for (int i = sheet.getFirstRowNum() + 1; i <= sheet.getPhysicalNumberOfRows(); ++i) {
                    row = sheet.getRow(i);
                    if (StringUtils.isEmpty((Object)row)) continue;
                    LinkedList<Object> linked = new LinkedList<Object>();
                    for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                        cell = row.getCell(j);
                        if (StringUtils.isEmpty((Object)cell)) continue;
                        value = ImportExcelTools.getCellValue(cell);
                        linked.add(value);
                    }
                    list.add(linked);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> readExcel(InputStream inputStream, Class<T> cls) {
        LinkedList<T> dataList = new LinkedList<T>();
        Workbook workbook = null;
        try {
            Field[] fields;
            workbook = WorkbookFactory.create((InputStream)inputStream);
            HashMap classMap = new HashMap();
            for (Field field : fields = cls.getDeclaredFields()) {
                ExcelColumn annotation = field.getAnnotation(ExcelColumn.class);
                if (annotation == null) continue;
                String value = annotation.value();
                if (!classMap.containsKey(value)) {
                    classMap.put(value, new ArrayList());
                }
                field.setAccessible(true);
                ((List)classMap.get(value)).add(field);
            }
            HashMap reflectionMap = new HashMap();
            int sheetsNumber = workbook.getNumberOfSheets();
            for (int n = 0; n < sheetsNumber; ++n) {
                Sheet sheet = workbook.getSheetAt(n);
                for (int j = sheet.getRow(0).getFirstCellNum(); j < sheet.getRow(0).getLastCellNum(); ++j) {
                    Object cellValue = ImportExcelTools.getCellValue(sheet.getRow(0).getCell(j));
                    if (!classMap.containsKey(cellValue)) continue;
                    reflectionMap.put(j, classMap.get(cellValue));
                }
                Row row = null;
                Cell cell = null;
                for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                    row = sheet.getRow(i);
                    T t = cls.newInstance();
                    for (int j = row.getFirstCellNum(); j < row.getLastCellNum(); ++j) {
                        cell = row.getCell(j);
                        if (!reflectionMap.containsKey(j)) continue;
                        Object cellValue = null;
                        try {
                            cellValue = ImportExcelTools.getCellValue(cell);
                        }
                        catch (Exception exx) {
                            cellValue = null;
                        }
                        List fieldList = (List)reflectionMap.get(j);
                        for (Field field : fieldList) {
                            try {
                                field.set(t, cellValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    dataList.add(t);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dataList = null;
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return dataList;
    }

    private static Object getCellValue(Cell cell) {
        Object value = null;
        switch (cell.getCellTypeEnum()) {
            case _NONE: {
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = FAST_DATE_FORMAT.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    break;
                }
                if ("@".equals(cell.getCellStyle().getDataFormatString()) || "General".equals(cell.getCellStyle().getDataFormatString()) || "0_ ".equals(cell.getCellStyle().getDataFormatString())) {
                    value = DECIMAL_FORMAT.format(cell.getNumericCellValue());
                    break;
                }
                if (POINTS_PATTERN.matcher(cell.getCellStyle().getDataFormatString()).matches()) {
                    value = cell.getNumericCellValue();
                    break;
                }
                if ("0.00E+00".equals(cell.getCellStyle().getDataFormatString())) {
                    value = cell.getNumericCellValue();
                    value = DECIMAL_FORMAT_NUMBER.format(value);
                    break;
                }
                if ("0.00%".equals(cell.getCellStyle().getDataFormatString())) {
                    value = cell.getNumericCellValue();
                    value = DECIMAL_FORMAT_PERCENT.format(value);
                    break;
                }
                if ("# ?/?".equals(cell.getCellStyle().getDataFormatString())) {
                    value = cell.getNumericCellValue();
                    break;
                }
                value = cell.getNumericCellValue();
                value = DecimalFormat.getCurrencyInstance().format(value);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case BLANK: {
                break;
            }
            default: {
                value = cell.toString();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportHSExcelByColumn(String title, String[] headers, String[] columns, Collection<T> dataset, OutputStream out, String pattern) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        sheet.setDefaultRowHeightInPoints(24.0f);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        CellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font2 = workbook.createFont();
        font.setBold(true);
        style2.setFont(font2);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Comment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new HSSFRichTextString("Created By Phil"));
        comment.setAuthor("phil");
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(style);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "yyyy/MM/dd";
        }
        FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
        Iterator<T> it = dataset.iterator();
        int index = 0;
        int count = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            count = headers.length < columns.length ? headers.length : columns.length;
            for (int i = 0; i < count; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(style2);
                String fieldName = columns[i];
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke((Object)t, new Object[0]);
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        textValue = instance.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, 2856);
                        byte[] bsValue = (byte[])value;
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(bsValue, 5));
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    HSSFRichTextString richString = new HSSFRichTextString(textValue);
                    Font font3 = workbook.createFont();
                    font3.setColor(IndexedColors.BLACK.index);
                    richString.applyFont(font3);
                    cell.setCellValue((RichTextString)richString);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXSExcelByColumn(String title, String[] headers, String[] columns, Collection<Map<String, Object>> dataset, OutputStream out, String pattern) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        Sheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        sheet.setDefaultRowHeightInPoints(24.0f);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        style.setFont(font);
        CellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        Font font2 = workbook.createFont();
        font.setBold(true);
        style2.setFont(font2);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Comment comment = patriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)new XSSFRichTextString("Created By Phil"));
        comment.setAuthor("phil");
        Row row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(style);
            XSSFRichTextString text = new XSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "yyyy/MM/dd";
        }
        FastDateFormat instance = FastDateFormat.getInstance((String)pattern);
        Iterator<Map<String, Object>> it = dataset.iterator();
        int index = 0;
        int count = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            Map<String, Object> map = it.next();
            count = headers.length < columns.length ? headers.length : columns.length;
            for (int i = 0; i < count; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(style2);
                try {
                    Object value = map.get(columns[i]);
                    String textValue = null;
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        textValue = instance.format(date);
                    } else if (value instanceof byte[]) {
                        row.setHeightInPoints(60.0f);
                        sheet.setColumnWidth(i, 2856);
                        byte[] bsValue = (byte[])value;
                        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 1023, 255, 6, index, 6, index);
                        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                        patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(bsValue, 5));
                    } else {
                        textValue = value != null ? value.toString() : "";
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    XSSFRichTextString richString = new XSSFRichTextString(textValue);
                    Font font3 = workbook.createFont();
                    font3.setColor(IndexedColors.BLACK.index);
                    richString.applyFont(font3);
                    cell.setCellValue((RichTextString)richString);
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)workbook);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

