/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.alibaba.fastjson.JSON;
import com.shinsoft.tools.model.common.LogFunction;
import java.lang.reflect.Modifier;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AspectTools {
    private static final Logger log = LogManager.getLogger(AspectTools.class);
    @Autowired
    private AmqpTemplate amqpTemplate;

    @Pointcut(value="execution(public * com.shinsoft..controller..*.*(..))")
    public void point1() {
    }

    @Pointcut(value="execution(public * com.shinsoft..Log*Mapper.*(..))")
    public void point2() {
    }

    @Pointcut(value="execution(public * com.shinsoft..LogReceiver.*(..))")
    public void point3() {
    }

    @Pointcut(value="point1()")
    public void point() {
    }

    @Before(value="point()")
    public void doBefore(JoinPoint joinPoint) {
        log.info("do before!");
    }

    @After(value="point()")
    public void doAfter(JoinPoint joinPoint) {
        log.info("do after!");
    }

    @AfterReturning(value="point()", returning="ans")
    public void doAfterReturning(JoinPoint joinPoint, String ans) {
        log.info("do after return: " + ans);
    }

    @Around(value="point()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Date startTime = new Date();
        long start = startTime.getTime();
        Object object = joinPoint.proceed();
        Date endTime = new Date();
        long end = endTime.getTime();
        long costTime = end - start;
        String methodName = joinPoint.getSignature().getName();
        LogFunction logFunction = new LogFunction();
        Object[] args = joinPoint.getArgs();
        String param = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) {
                log.info("\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570\u4e3a:" + args[i]);
                if (args[i] instanceof HttpServletRequest) {
                    HttpServletRequest request = (HttpServletRequest)args[i];
                    logFunction.setRequestId(request.getHeader("logId"));
                    logFunction.setLogId(request.getHeader("logId"));
                    continue;
                }
                param = param + args[i].toString() + ";";
                continue;
            }
            log.info("\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570\u4e3a:null");
        }
        log.info("\u76ee\u6807\u65b9\u6cd5\u540d\u4e3a:" + joinPoint.getSignature().getName());
        log.info("\u76ee\u6807\u65b9\u6cd5\u6240\u5c5e\u7c7b\u7684\u7b80\u5355\u7c7b\u540d:" + joinPoint.getSignature().getDeclaringType().getSimpleName());
        log.info("\u76ee\u6807\u65b9\u6cd5\u6240\u5c5e\u7c7b\u7684\u7c7b\u540d:" + joinPoint.getSignature().getDeclaringTypeName());
        log.info("\u76ee\u6807\u65b9\u6cd5\u58f0\u660e\u7c7b\u578b:" + Modifier.toString(joinPoint.getSignature().getModifiers()));
        log.info("\u88ab\u4ee3\u7406\u7684\u5bf9\u8c61:" + joinPoint.getTarget());
        log.info("\u4ee3\u7406\u5bf9\u8c61\u81ea\u5df1:" + joinPoint.getThis());
        log.info("*************** Run the  method --> {} total  cost  time  is {}  ms********************", (Object)methodName, (Object)costTime);
        logFunction.setClassName(joinPoint.getSignature().getDeclaringTypeName() + "." + methodName);
        logFunction.setDuration(costTime);
        logFunction.setStartTime(startTime);
        logFunction.setEndTime(endTime);
        param = param.length() > 500 ? param.substring(0, 499) : param;
        logFunction.setParams(param);
        this.amqpTemplate.convertAndSend("log", "function", (Object)JSON.toJSONString((Object)logFunction));
        return object;
    }
}

