-- Create table
create table T_EXP_SEARCH_FIRST
(
first_name              VARCHAR2(50),
id                      VARCHAR2(32) not null,
process_instance_id     VARCHAR2(32),
process_instance_status VARCHAR2(50),
add_id                  VARCHAR2(32),
add_code                VARCHAR2(50),
add_name                VARCHAR2(50),
add_dept_id             VARCHAR2(50),
add_dept_code           VARCHAR2(50),
add_dept_name           VARCHAR2(50),
add_time                DATE,
modify_id               VARCHAR2(32),
modify_code             VARCHAR2(50),
modify_name             VARCHAR2(50),
modify_time             DATE,
cancel_id               VARCHAR2(32),
cancel_code             VARCHAR2(50),
cancel_name             VARCHAR2(50),
cancel_time             DATE,
cancel_flag             VARCHAR2(50),
belong_id               VARCHAR2(32)
)
tablespace ${tableSpace}
pctfree 10
initrans 1
maxtrans 255
storage
(
initial 16K
next 8K
minextents 1
maxextents unlimited
);
-- Add comments to the columns
comment on column T_EXP_SEARCH_FIRST.first_name
is '名称一';
comment on column T_EXP_SEARCH_FIRST.id
is '主键';
comment on column T_EXP_SEARCH_FIRST.process_instance_id
is '流程id';
comment on column T_EXP_SEARCH_FIRST.process_instance_status
is '流程状态';
comment on column T_EXP_SEARCH_FIRST.add_id
is '添加人id';
comment on column T_EXP_SEARCH_FIRST.add_code
is '添加人编码';
comment on column T_EXP_SEARCH_FIRST.add_name
is '添加人名称';
comment on column T_EXP_SEARCH_FIRST.add_dept_id
is '添加部门id';
comment on column T_EXP_SEARCH_FIRST.add_dept_code
is '添加部门编码';
comment on column T_EXP_SEARCH_FIRST.add_dept_name
is '添加部门名称';
comment on column T_EXP_SEARCH_FIRST.add_time
is '添加时间';
comment on column T_EXP_SEARCH_FIRST.modify_id
is '修改人id';
comment on column T_EXP_SEARCH_FIRST.modify_code
is '修改人编码';
comment on column T_EXP_SEARCH_FIRST.modify_name
is '修改人名称';
comment on column T_EXP_SEARCH_FIRST.modify_time
is '修改时间';
comment on column T_EXP_SEARCH_FIRST.cancel_id
is '作废人id';
comment on column T_EXP_SEARCH_FIRST.cancel_code
is '作废人编码';
comment on column T_EXP_SEARCH_FIRST.cancel_name
is '作废人名称';
comment on column T_EXP_SEARCH_FIRST.cancel_time
is '作废时间';
comment on column T_EXP_SEARCH_FIRST.cancel_flag
is '作废标记';
comment on column T_EXP_SEARCH_FIRST.belong_id
is 'BELONG_ID';
-- Create/Recreate primary, unique and foreign key constraints
alter table T_EXP_SEARCH_FIRST
add constraint T_EXP_SEARCH_FIRST_PK primary key (ID)
using index
tablespace ${tableSpace}
pctfree 10
initrans 2
maxtrans 255
storage
(
initial 64K
next 1M
minextents 1
maxextents unlimited
);
