-- drop table   SYS_ROLE  ;
create table SYS_ROLE
(
  id          VARCHAR2(200) not null,
  role_code   VARCHAR2(50),
  role_name   VARCHAR2(50),
  add_id      VARCHAR2(200),
  add_time    DATE,
  modify_id   VARCHAR2(200),
  modify_time DATE,
  cancel_id   VARCHAR2(200),
  cancel_time DATE,
  cancel_flag VARCHAR2(1),
  belong_id   VARCHAR2(32)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_ROLE.cancel_flag
  is '0存在9不存在';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_ROLE
  add constraint SYS_ROLE_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
