-- drop table     ;
create table ${tableName}
(
<#list fields as field>
    <#if field.columnType =="VARCHAR2">
        ${field.columnName}      ${field.columnType}(${field.length}) <#if field.nullFlag>not null</#if> <#sep>,</#sep>
    <#elseif field.columnType =="NUMBER">
        ${field.columnName}      ${field.columnType}(${field.length},${field.precision})<#sep>,</#sep>
    <#elseif field.columnType =="DATE">
        ${field.columnName}      ${field.columnType}<#sep>,</#sep>
    </#if>
</#list>
)
tablespace ${tableSpace}
pctfree 10
initrans 1
maxtrans 255
storage
(
initial 64
next 1
minextents 1
maxextents unlimited
);
-- Add comments to the columns

<#list fields as field>
    comment on column ${tableName}.${field.columnName}
    is '${field.comment}';
</#list>

-- Create/Recreate primary, unique and foreign key constraints
alter table ${tableName}
add constraint ${tableName}_PK primary key (ID)
using index
tablespace ${tableSpace}
pctfree 10
initrans 2
maxtrans 255
storage
(
initial 64K
next 1M
minextents 1
maxextents unlimited
);
