package ${package.Controller};

import ${package.Service}.${entity}Service;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResponseCodeMsg;
import com.shinsoft.tools.model.common.ResultJSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Date;

@RestController
@RequestMapping(value = "/${entity}")
public class ${entity}Controller {
@Autowired
${table.entityName}Service ${table.entityPath}Service;

ResultJSON resultJSON;

@RequestMapping(value = "/queryPopup")
public ResultJSON queryPopup(int page, int rows,
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName >
            <#if query.controllerType =='日期' >
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}Begin,
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}End,
            <#elseif query.controllerType =='日期时间' >
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}Begin,
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}End,
            <#else>
                ${field.propertyType} ${field.propertyName},
            </#if>
        </#if>
    </#list>
</#list>
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.queryPopup(userId, menuId, belongId, page, rows<#if cfg.querys?? && (cfg.querys?size > 0) >, </#if>
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName >
            <#if query.controllerType =='日期' >
                ${field.propertyName}Begin,
                ${field.propertyName}End<#sep>,</#sep>
            <#elseif query.controllerType =='日期时间' >
                ${field.propertyName}Begin,
                ${field.propertyName}End<#sep>,</#sep>
            <#else>
                ${field.propertyName}<#sep>,</#sep>
            </#if>
        </#if>
    </#list>
</#list> );
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}

@RequestMapping(value = "/queryPage")
public ResultJSON queryPage(int page, int rows,
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName >
            <#if query.controllerType =='日期' >
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}Begin,
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}End,
            <#elseif query.controllerType =='日期时间' >
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}Begin,
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}End,
            <#else>
                ${field.propertyType} ${field.propertyName},
            </#if>
        </#if>
    </#list>
</#list>
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.queryPage(userId, menuId, belongId, page, rows<#if cfg.querys?? && (cfg.querys?size > 0) >, </#if>
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName >
            <#if query.controllerType =='日期' >
                ${field.propertyName}Begin,
                ${field.propertyName}End<#sep>,</#sep>
            <#elseif query.controllerType =='日期时间' >
                ${field.propertyName}Begin,
                ${field.propertyName}End<#sep>,</#sep>
            <#else>
                ${field.propertyName}<#sep>,</#sep>
            </#if>
        </#if>
    </#list>
</#list> );
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}

@RequestMapping(value = "/queryByPK")
public ResultJSON queryByPK(String id,
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.queryByPK(userId, menuId, belongId, id);
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}


@RequestMapping(value = "/save", method = RequestMethod.POST)
public ResultJSON save(String json,
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.save(userId, menuId, belongId, json);
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}

@RequestMapping(value = "/remove", method = RequestMethod.POST)
public ResultJSON remove(String id,
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.remove(userId, menuId, belongId, id);
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}

@RequestMapping(value = "/removeBatch", method = RequestMethod.POST)
public ResultJSON remove(String[] ids,
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.removeBatch(userId, menuId, belongId, ids);
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}


@RequestMapping(value = "/start", method = RequestMethod.POST)
public ResultJSON start(String id,
HttpServletRequest request) {
try {
String userId = (String) request.getHeader("userId");
String menuId = (String) request.getHeader("menuId");
String belongId = (String) request.getHeader("belongId");
resultJSON = ${table.entityPath}Service.start(userId, menuId, belongId, id);
} catch (Exception ex) {
resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ex);
ex.printStackTrace();
} finally {
return resultJSON;
}
}




@RequestMapping(value = "/export")
public void export(
String userId,
String menuId,
String belongId,
String tName,
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName >
            <#if query.controllerType =='日期' >
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}Begin,
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}End,
            <#elseif query.controllerType =='日期时间' >
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}Begin,
                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
                ${field.propertyType} ${field.propertyName}End,
            <#else>
                ${field.propertyType} ${field.propertyName},
            </#if>
        </#if>
    </#list>
</#list>
HttpServletRequest request,
HttpServletResponse response) {
try {

 ${table.entityPath}Service.export(response, userId, menuId, belongId, tName<#if cfg.querys?? && (cfg.querys?size > 0) >, </#if>
<#list table.fields as field>
    <#list cfg.querys as query>
        <#if field.name == query.fieldName >
            <#if query.controllerType =='日期' >
                ${field.propertyName}Begin,
                ${field.propertyName}End<#sep>,</#sep>
            <#elseif query.controllerType =='日期时间' >
                ${field.propertyName}Begin,
                ${field.propertyName}End<#sep>,</#sep>
            <#else>
                ${field.propertyName}<#sep>,</#sep>
            </#if>
        </#if>
    </#list>
</#list> );

} catch (Exception ex) {
ex.printStackTrace();
}
}



}
