-- drop table    T_COMMON_BUSINESS_PROCESS ;
create table T_COMMON_BUSINESS_PROCESS
(
  id                VARCHAR2(32) not null,
  db_table_name     VARCHAR2(200),
  process_name      VARCHAR2(200),
  process_key       VARCHAR2(200),
  business_name_sql VARCHAR2(200),
  path_web          VARCHAR2(200),
  path_app          VARCHAR2(200),
  path_applet       VARCHAR2(200),
  add_id            VARCHAR2(200),
  add_time          DATE,
  modify_id         VARCHAR2(200),
  modify_time       DATE,
  cancel_id         VARCHAR2(200),
  cancel_time       DATE,
  cancel_flag       VARCHAR2(1),
  service_name      VARCHAR2(200),
  db_driver         VARCHAR2(200),
  db_url            VARCHAR2(200),
  db_username       VARCHAR2(200),
  db_password       VARCHAR2(200),
  belong_id         VARCHAR2(32)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Create/Recreate primary, unique and foreign key constraints
alter table T_COMMON_BUSINESS_PROCESS
  add constraint T_COMMON_BUSINESS_PROCESS_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
