-- drop table   SYS_DEPARTMENT  ;
create table SYS_DEPARTMENT
(
  id          VARCHAR2(32) not null,
  dept_name   VARCHAR2(200),
  f_id        VARCHAR2(200) not null,
  dept_desc   VARCHAR2(200),
  add_id      VARCHAR2(32),
  add_time    DATE,
  modify_id   VARCHAR2(32),
  modify_time DATE,
  dept_code   VARCHAR2(50),
  cancel_id   VARCHAR2(200),
  cancel_time DATE,
  cancel_flag VARCHAR2(1),
  belong_id   VARCHAR2(32)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_DEPARTMENT.cancel_flag
  is '0存在9不存在';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_DEPARTMENT
  add constraint SYS_DEPARTMENT_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
