-- drop table     ;
create table SYS_USER
(
  id               VARCHAR2(32) not null,
  user_code        VARCHAR2(200),
  user_name        VARCHAR2(200),
  user_desc        VARCHAR2(200),
  password         VARCHAR2(200),
  is_used          VARCHAR2(1),
  id_card          VARCHAR2(200),
  phone            VARCHAR2(200),
  mobile           VARCHAR2(200),
  memo             VARCHAR2(200),
  add_id           VARCHAR2(32),
  add_code         VARCHAR2(200),
  add_name         VARCHAR2(200),
  add_time         DATE,
  modify_id        VARCHAR2(32),
  modify_code      VARCHAR2(200),
  modify_name      VARCHAR2(200),
  modify_time      DATE,
  cancel_flag      VARCHAR2(1),
  cancel_id        VARCHAR2(32),
  cancel_code      VARCHAR2(200),
  cancel_name      VARCHAR2(200),
  cancel_time      DATE,
  belong_id        VARCHAR2(32),
  belong_dept_code VARCHAR2(200),
  belong_dept_name VARCHAR2(200),
  admin_flag       VARCHAR2(1)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_USER.cancel_flag
  is '0存在9不存在';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_USER
  add constraint SYS_USER_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
