-- drop table     ;
create table SYS_TABLE_FIELD
(
  id                  VARCHAR2(32) not null,
  service_name        VARCHAR2(200),
  sort                NUMBER(9),
  table_name          VARCHAR2(200),
  field_name          VARCHAR2(200),
  field_type          VARCHAR2(200),
  field_comment       VARCHAR2(200),
  data_length         NUMBER(9),
  data_precision      NUMBER(9),
  null_flag           VARCHAR2(5),
  pk_flag             VARCHAR2(5),
  controller_type     VARCHAR2(200),
  input_flag          VARCHAR2(5),
  require_flag        VARCHAR2(5),
  query_flag          VARCHAR2(5),
  fuzzy_flag          VARCHAR2(5),
  date_flag           VARCHAR2(5),
  show_flag           VARCHAR2(5),
  label               VARCHAR2(200),
  prop                VARCHAR2(200),
  width               VARCHAR2(200),
  header_align        VARCHAR2(200),
  align               VARCHAR2(200),
  formatter           VARCHAR2(200),
  sortable            VARCHAR2(200),
  col_type            VARCHAR2(200),
  module_name         VARCHAR2(200),
  parent_package_name VARCHAR2(200),
  process_key         VARCHAR2(200),
  vue_path            VARCHAR2(200),
  table_prefix        VARCHAR2(200),
  process_name        VARCHAR2(200)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_TABLE_FIELD
  add constraint SYS_TABLE_FIELD_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
