/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TokenTools {
    private static final String ISSUER = "framework";
    private static final String AUDIENCE = "web";
    private static final int EXPIRES_IN = 60;
    private static final String encryKey = "XX#$%()(#*!()!KL<><MQLMNQNQJQK sdfkjsdrow32234545fdf>?N<:{LWPW";
    private static final Algorithm ALGORITHM = Algorithm.HMAC256((String)"XX#$%()(#*!()!KL<><MQLMNQNQJQK sdfkjsdrow32234545fdf>?N<:{LWPW");

    public static String generateToken(Map<String, Object> map) {
        long currentTime = System.currentTimeMillis();
        String token = JWT.create().withIssuer(ISSUER).withIssuedAt(new Date(currentTime)).withExpiresAt(new Date(currentTime + 3600000L)).withClaim("userId", map.get("userId").toString()).sign(ALGORITHM);
        return token;
    }

    public static Map<String, Object> verifyToken(String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JWTVerifier verifier = JWT.require((Algorithm)ALGORITHM).withIssuer(new String[]{ISSUER}).build();
            DecodedJWT decodedJWT = verifier.verify(token);
            String issuer = decodedJWT.getIssuer();
            String userId = decodedJWT.getClaim("userId").asString();
            Date expiresAt = decodedJWT.getExpiresAt();
            map.put("userId", userId);
            map.put("expiresAt", expiresAt);
        }
        catch (TokenExpiredException e) {
            throw new Exception("token \u65e0\u6cd5\u89e3\u6790");
        }
        finally {
            return map;
        }
    }
}

