/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DBTools {
    private static String url_local;
    private static String driver_local;
    private static String username_local;
    private static String password_local;

    @Value(value="${spring.datasource.url}")
    public void setUrl_local(String url_local) {
        DBTools.url_local = url_local;
    }

    @Value(value="${spring.datasource.driver-class-name}")
    public void setDriver_local(String driver_local) {
        DBTools.driver_local = driver_local;
    }

    @Value(value="${spring.datasource.username}")
    public void setUsername_local(String username_local) {
        DBTools.username_local = username_local;
    }

    @Value(value="${spring.datasource.password}")
    public void setPassword_local(String password_local) {
        DBTools.password_local = password_local;
    }

    public static Connection getConnection() {
        return DBTools.getConnection(driver_local, url_local, username_local, password_local);
    }

    public static Connection getConnection(String driver, String url, String username, String password) {
        try {
            Class.forName(driver);
            return DriverManager.getConnection(url, username, password);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean executeUpdate(String sql, Object ... args) {
        Connection conn = DBTools.getConnection();
        return DBTools.executeUpdate(conn, sql, args);
    }

    public static List<Map<String, Object>> executeQuery(String sql, Object ... args) {
        Connection conn = DBTools.getConnection();
        return DBTools.executeQuery(conn, sql, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeUpdate(Connection conn, String sql, Object ... args) {
        PreparedStatement ps = null;
        try {
            int i;
            ps = conn.prepareStatement(sql);
            for (i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
            i = ps.executeUpdate();
            if (i > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DBTools.close(conn, ps, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(Connection conn, String sql) {
        PreparedStatement ps = null;
        try {
            boolean b;
            ps = conn.prepareStatement(sql);
            boolean bl = b = ps.execute();
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            DBTools.close(conn, ps, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Map<String, Object>> executeQuery(Connection conn, String sql, Object ... args) {
        ArrayList<Map<String, Object>> arrayList;
        PreparedStatement ps = null;
        ResultSet set = null;
        try {
            ps = conn.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
            set = ps.executeQuery();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            int count = set.getMetaData().getColumnCount();
            while (set.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < count; ++i) {
                    String name = set.getMetaData().getColumnLabel(i + 1);
                    map.put(name, set.getObject(name));
                }
                list.add(map);
            }
            arrayList = list;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBTools.close(conn, ps, set);
                throw throwable;
            }
            DBTools.close(conn, ps, set);
            return null;
        }
        DBTools.close(conn, ps, set);
        return arrayList;
    }

    private static void close(Connection conn, PreparedStatement st, ResultSet set) {
        try {
            if (set != null) {
                set.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

