-- drop table   T_COMMON_FILE_PATH  ;
create table T_COMMON_FILE_PATH
(
  id          VARCHAR2(32) not null,
  f_id        VARCHAR2(32) not null,
  file_name   VARCHAR2(500),
  file_path   VARCHAR2(500),
  file_type   VARCHAR2(500),
  file_size   VARCHAR2(500),
  add_id      VARCHAR2(32),
  add_time    DATE,
  modify_id   VARCHAR2(32),
  modify_time DATE,
  cancel_flag VARCHAR2(1),
  cancel_id   VARCHAR2(32),
  cancel_time DATE,
  sort        NUMBER(9),
  belong_id   VARCHAR2(32)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column T_COMMON_FILE_PATH.add_id
  is '录入人员';
comment on column T_COMMON_FILE_PATH.add_time
  is '录入时间';
comment on column T_COMMON_FILE_PATH.modify_id
  is '修改人员';
comment on column T_COMMON_FILE_PATH.modify_time
  is '修改时间';
comment on column T_COMMON_FILE_PATH.cancel_flag
  is '作废标记';
comment on column T_COMMON_FILE_PATH.cancel_id
  is '作废人员';
comment on column T_COMMON_FILE_PATH.cancel_time
  is '作废时间';
-- Create/Recreate primary, unique and foreign key constraints
alter table T_COMMON_FILE_PATH
  add constraint T_COMMON_FILE_PATH_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
