-- drop table    SYS_TABLE_PERSONAL ;
create table SYS_TABLE_PERSONAL
(
  id           VARCHAR2(32) not null,
  user_id      VARCHAR2(32),
  menu_id      VARCHAR2(32),
  t_name       VARCHAR2(200),
  show_flag    VARCHAR2(200),
  label        VARCHAR2(200),
  prop         VARCHAR2(200),
  width        VARCHAR2(200),
  header_align VARCHAR2(200),
  align        VARCHAR2(200),
  formatter    VARCHAR2(200),
  sortable     VARCHAR2(200),
  sort         NUMBER(9),
  col_type     VARCHAR2(200),
  export_flag  VARCHAR2(1)
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_TABLE_PERSONAL
  add constraint SYS_TABLE_PERSONAL_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
