-- drop table  SYS_RAS_KEY   ;
create table SYS_RAS_KEY
(
  public_key  VARCHAR2(1000) not null,
  private_key VARCHAR2(1000) not null,
  add_time    DATE,
  id          VARCHAR2(32) not null
)
tablespace ${tableSpace}
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 16
    next 8
    minextents 1
    maxextents unlimited
  )
nologging;
-- Add comments to the columns
comment on column SYS_RAS_KEY.public_key
  is '公钥';
comment on column SYS_RAS_KEY.private_key
  is '私钥';
comment on column SYS_RAS_KEY.add_time
  is '添加时间';
-- Create/Recreate primary, unique and foreign key constraints
alter table SYS_RAS_KEY
  add constraint SYS_RAS_KEY_PK primary key (ID)
  using index
  tablespace ${tableSpace}
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
