create table ${tableName}
(
<#list fields as field>
    <#if field.fieldType =="varchar">
        ${field.fieldName}      ${field.fieldType}(${field.dataLength?c}) <#if field.nullFlag  =="1">NOT NULL<#else>DEFAULT NULL</#if> COMMENT '${field.fieldComment}',
    <#elseif field.fieldType =="int">
        ${field.fieldName}      ${field.fieldType}(${field.dataLength?c}) <#if field.nullFlag  =="1">NOT NULL<#else>DEFAULT NULL</#if> COMMENT '${field.fieldComment}',
    <#elseif field.fieldType =="float">
        ${field.fieldName}      ${field.fieldType}(${field.dataLength?c},${field.dataPrecision?c}) <#if field.nullFlag  =="1">NOT NULL<#else>DEFAULT NULL</#if> COMMENT '${field.fieldComment}',
    <#elseif field.fieldType =="double">
        ${field.fieldName}      ${field.fieldType}(${field.dataLength?c},${field.dataPrecision?c}) <#if field.nullFlag  =="1">NOT NULL<#else>DEFAULT NULL</#if> COMMENT '${field.fieldComment}',
    <#elseif field.fieldType =="date">
        ${field.fieldName}      ${field.fieldType} <#if field.nullFlag  =="1">NOT NULL<#else>DEFAULT NULL</#if> COMMENT '${field.fieldComment}',
    <#elseif field.fieldType =="datetime">
        ${field.fieldName}      ${field.fieldType} <#if field.nullFlag  =="1">NOT NULL<#else>DEFAULT NULL</#if> COMMENT '${field.fieldComment}',
    </#if>
</#list>
PRIMARY KEY (ID)
)  ROW_FORMAT = DYNAMIC CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
