-- drop table     ;
create table ${tableName}
(
<#list fields as field>
    <#if field.fieldType =="VARCHAR2">
        ${field.fieldName}      ${field.fieldType}(${field.length}) <#if field.nullFlag  =="1">not null</#if> <#sep>,</#sep>
    <#elseif field.fieldType =="NUMBER">
        ${field.fieldName}      ${field.fieldType}(${field.length},${field.precision})<#sep>,</#sep>
    <#elseif field.fieldType =="DATE">
        ${field.fieldName}      ${field.fieldType}<#sep>,</#sep>
    </#if>
</#list>
)
tablespace ${tableSpace}
pctfree 10
initrans 1
maxtrans 255
storage
(
initial 64
next 1
minextents 1
maxextents unlimited
);
-- Add comments to the columns

<#list fields as field>
    comment on column ${tableName}.${field.fieldName}
    is '${field.fieldComment}';
</#list>

-- Create/Recreate primary, unique and foreign key constraints
alter table ${tableName}
add constraint ${tableName}_PK primary key (ID)
using index
tablespace ${tableSpace}
pctfree 10
initrans 2
maxtrans 255
storage
(
initial 64K
next 1M
minextents 1
maxextents unlimited
);
