package ${cfg.parentPackageName}.api;

import ${package.Service}.${entity}Service;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResponseCodeMsg;
import com.shinsoft.tools.model.common.ResultJSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;

@RestController
@RequestMapping(value = "/api/${entity}")
public class ${entity}API {
    @Autowired
    ${table.entityName}Service ${table.entityPath}Service;

    ResultJSON resultJSON;

    @RequestMapping(value = "/queryByPK")
    public ResultJSON queryByPK(String userId,
                                String menuId,
                                String belongId,
                                String id,
                                HttpServletRequest request) {
        try {
            resultJSON = ${table.entityPath}Service.queryByPK(userId, menuId, belongId, id);
        } catch (Exception ex) {
            resultJSON = JSONTools.toResultJSON(ResponseCodeMsg.CODE_EX, ExceptionTools.getExceptionAllinformation(ex));
            ex.printStackTrace();
        } finally {
            return resultJSON;
        }
    }

//@FeignClient(name = "${cfg.serviceName}")
//public interface ${cfg.moduleName}Service {
//   @RequestMapping(value = "/api/${table.entityName}/queryByPK", method = RequestMethod.GET)
//   ResultJSON queryByPK(@RequestParam("userId") String userId,
//                        @RequestParam("menuId") String menuId,
//                        @RequestParam("belongId") String belongId,
//                        @RequestParam("id") String id);
//}

}
