/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools.mybatisplus;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"com.shinsoft.**.mapper"})
public class MybatisPlusConfig {
    private static String driver_local;

    @Value(value="${spring.datasource.driver-class-name}")
    public void setDriver_local(String driver_local) {
        MybatisPlusConfig.driver_local = driver_local;
    }

    @Bean
    public DatabaseIdProvider databaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties p = new Properties();
        p.setProperty("Oracle", "oracle");
        p.setProperty("MySQL", "mysql");
        p.setProperty("PostgreSQL", "postgresql");
        p.setProperty("DB2", "db2");
        p.setProperty("SQL Server", "sqlserver");
        p.setProperty("DM DBMS", "dameng");
        databaseIdProvider.setProperties(p);
        return databaseIdProvider;
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return new MybatisPlusCustomizers();
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        PaginationInnerInterceptor paginationInnerInterceptor = driver_local.contains("oracle") ? new PaginationInnerInterceptor(DbType.ORACLE) : (driver_local.contains("mysql") ? new PaginationInnerInterceptor(DbType.MYSQL) : (driver_local.contains("DmDriver") ? new PaginationInnerInterceptor(DbType.DM) : new PaginationInnerInterceptor(DbType.ORACLE)));
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        return interceptor;
    }

    class MybatisPlusCustomizers
    implements ConfigurationCustomizer {
        MybatisPlusCustomizers() {
        }

        public void customize(MybatisConfiguration configuration) {
            configuration.setJdbcTypeForNull(JdbcType.NULL);
        }
    }
}

