/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.shinsoft.tools.model.common.ResultJSON;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Component
public class S3Tools {
    private static final Logger log = LoggerFactory.getLogger(S3Tools.class);
    @Value(value="${s3.endpoint}")
    String endpoint;
    @Value(value="${s3.accessKey}")
    String accessKey;
    @Value(value="${s3.secretKey}")
    String secretKey;
    @Value(value="${s3.bucket}")
    String defaultBucket;
    ResultJSON resultJSON;

    public ResultJSON putObject(String bucket, MultipartFile multipartFile, String filePath) throws Exception {
        System.out.println("S3 putObject bucket:::" + bucket);
        System.out.println("S3 putObject filePath:::" + filePath);
        InputStream inputStream = multipartFile.getInputStream();
        S3Client s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)"cn-east-1"))).endpointOverride(URI.create(this.endpoint))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey)))).build();
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(filePath).contentType(multipartFile.getContentType()).build();
        s3.putObject(request, RequestBody.fromInputStream((InputStream)inputStream, (long)multipartFile.getSize()));
        return null;
    }

    public ResultJSON putObject(String bucket, String filePath, String targetPath) throws Exception {
        S3Client s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)"cn-east-1"))).endpointOverride(URI.create(this.endpoint))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey)))).build();
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(filePath).build();
        s3.putObject(request, RequestBody.fromFile((File)new File(targetPath)));
        return null;
    }

    public InputStream getObject(String bucket, String key) {
        S3Client s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)"cn-east-1"))).endpointOverride(URI.create(this.endpoint))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey)))).build();
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
        return s3.getObject(request);
    }
}

