/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.alibaba.fastjson.JSON;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.DownloadUrl;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResultJSON;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class QiniuTools {
    private static final Logger log = LoggerFactory.getLogger(QiniuTools.class);
    @Value(value="${qiniu.domain}")
    String domain;
    @Value(value="${qiniu.accessKey}")
    String accessKey;
    @Value(value="${qiniu.secretKey}")
    String secretKey;
    @Value(value="${qiniu.bucket}")
    String defaultSpace;
    ResultJSON resultJSON;

    public ResultJSON putObject(String bucket, MultipartFile file, String filePath) throws IOException {
        InputStream inputStream = file.getInputStream();
        Region region = new Region.Builder().region("z0").accUpHost(new String[]{"up-qos.sdgt.com"}).srcUpHost(new String[]{"up-qos.sdgt.com"}).iovipHost("io-qos.sdgt.com").rsHost("rs-qos.sdgt.com").rsfHost("rsf-qos.sdgt.com").apiHost("api-qos.sdgt.com").build();
        Configuration cfg = new Configuration(region);
        cfg.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V2;
        cfg.useHttpsDomains = false;
        UploadManager uploadManager = new UploadManager(cfg);
        String key = filePath;
        Auth auth = Auth.create((String)this.accessKey, (String)this.secretKey);
        if (StringUtils.isEmpty((CharSequence)bucket)) {
            bucket = this.defaultSpace;
        }
        String upToken = auth.uploadToken(bucket);
        Response response = uploadManager.put(inputStream, key, upToken, null, null);
        System.out.println(response.statusCode);
        System.out.println(response.bodyString());
        System.out.println(response.error);
        if (response.statusCode != 200) {
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25" + response.error);
        }
        DefaultPutRet putRet = (DefaultPutRet)JSON.parseObject((String)response.bodyString(), DefaultPutRet.class);
        System.out.println(putRet.key);
        System.out.println(putRet.hash);
        this.resultJSON = JSONTools.toResultJSON(putRet.key);
        return this.resultJSON;
    }

    public InputStream getObject(String bucket, String filePath) throws IOException {
        String realDomain = this.domain;
        if (StringUtils.isNotEmpty((CharSequence)bucket)) {
            realDomain = this.domain.replace(this.defaultSpace, bucket);
        }
        boolean useHttps = false;
        String key = filePath;
        DownloadUrl url = new DownloadUrl(realDomain, useHttps, key);
        long expireInSeconds = 600L;
        long deadline = System.currentTimeMillis() / 1000L + expireInSeconds;
        Auth auth = Auth.create((String)this.accessKey, (String)this.secretKey);
        String urlString = url.buildURL(auth, deadline);
        System.out.println(urlString);
        URL realDownloadUrl = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)realDownloadUrl.openConnection();
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return connection.getInputStream();
        }
        InputStream errorStream = connection.getErrorStream();
        String errorMessage = "HTTP Error: " + responseCode;
        throw new IOException("\u4e0b\u8f7d\u5931\u8d25\uff0cHTTP\u72b6\u6001\u7801: " + responseCode + ", \u9519\u8bef\u4fe1\u606f: " + errorMessage);
    }
}

