/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import java.net.URI;
import java.util.List;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class QiniuS3BucketService {
    private final S3Client s3Client;

    public QiniuS3BucketService(String endpoint, String accessKey, String secretKey) {
        this.s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.CN_NORTH_1)).endpointOverride(URI.create(endpoint))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)))).build();
    }

    public List<Bucket> listBuckets() {
        try {
            ListBucketsRequest request = (ListBucketsRequest)ListBucketsRequest.builder().build();
            ListBucketsResponse response = this.s3Client.listBuckets(request);
            return response.buckets();
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6 Bucket \u5217\u8868\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean createBucket(String bucketName) {
        try {
            CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
            this.s3Client.createBucket(request);
            System.out.println("Bucket \u521b\u5efa\u6210\u529f: " + bucketName);
            return true;
        }
        catch (S3Exception e) {
            System.err.println("\u521b\u5efa Bucket \u5931\u8d25: " + e.awsErrorDetails().errorMessage());
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            System.err.println("\u521b\u5efa Bucket \u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        if (this.s3Client != null) {
            this.s3Client.close();
        }
    }
}

