/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.tools;

import com.shinsoft.tools.FileTools;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioTools {
    private static final Logger log = LoggerFactory.getLogger(MinioTools.class);
    @Autowired
    private MinioClient minioClient;
    @Value(value="${minio.bucket}")
    private String defaultBucket;
    @Value(value="${minio.endpoint}")
    private String endpoint;
    @Value(value="${minio.accessKey}")
    private String accessKey;
    @Value(value="${minio.secretKey}")
    private String secretKey;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> putObject(MultipartFile file) throws IOException, ServerException, InsufficientDataException, InternalException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, XmlParserException, ErrorResponseException {
        String bucketName = "default";
        String originalFilename = file.getOriginalFilename();
        InputStream inputStream = file.getInputStream();
        try {
            long size = file.getSize();
            String filePath = this.createFilePath(originalFilename);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(filePath)).stream(inputStream, size, -1L).contentType(file.getContentType()).build());
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("filePath", filePath);
            result.put("fileUrl", this.endpoint + "/" + bucketName + "/" + filePath);
            result.put("fileName", FileTools.getFileName(filePath));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> putObject(MultipartFile file, String filePath) throws IOException, ServerException, InsufficientDataException, InternalException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, XmlParserException, ErrorResponseException {
        String bucketName = "default";
        InputStream inputStream = file.getInputStream();
        try {
            long size = file.getSize();
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(filePath)).stream(inputStream, size, -1L).contentType(file.getContentType()).build());
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("filePath", filePath);
            result.put("fileUrl", this.endpoint + "/" + bucketName + "/" + filePath);
            result.put("fileName", FileTools.getFileName(filePath));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> putObject(MultipartFile file, String filePath, String fileName) throws IOException, ServerException, InsufficientDataException, InternalException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, XmlParserException, ErrorResponseException {
        String bucketName = "default";
        InputStream inputStream = file.getInputStream();
        try {
            long size = file.getSize();
            String fullPath = this.createFilePath(filePath, fileName);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fullPath)).stream(inputStream, size, -1L).contentType(file.getContentType()).build());
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("filePath", filePath);
            result.put("fileUrl", this.endpoint + "/" + bucketName + "/" + filePath);
            result.put("fileName", FileTools.getFileName(filePath));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> putObject(String bucket, MultipartFile file, String filePath) throws IOException, ServerException, InsufficientDataException, InternalException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, XmlParserException, ErrorResponseException {
        if (StringUtils.isEmpty((CharSequence)bucket)) {
            bucket = this.defaultBucket;
        }
        InputStream inputStream = file.getInputStream();
        try {
            long size = file.getSize();
            System.out.println("putObject bucket:::" + bucket);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(filePath)).stream(inputStream, size, -1L).contentType(file.getContentType()).build());
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("filePath", filePath);
            result.put("fileUrl", this.endpoint + "/" + bucket + "/" + filePath);
            result.put("fileName", FileTools.getFileName(filePath));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    public Map<String, String> putXlsxExcelByStream(String fileCatalogue, InputStream inputStream, String fileName) throws IOException, ServerException, InsufficientDataException, InternalException, InvalidResponseException, InvalidKeyException, NoSuchAlgorithmException, XmlParserException, ErrorResponseException {
        String bucketName = "default";
        long size = inputStream.available();
        String filePath = this.createFilePath(fileCatalogue, fileName);
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(filePath)).stream(inputStream, size, -1L).contentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet").build());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("filePath", filePath);
        result.put("fileUrl", this.endpoint + "/" + bucketName + "/" + filePath);
        result.put("fileName", FileTools.getFileName(filePath));
        return result;
    }

    public InputStream getObject(String bucket, String filePath, String fileName) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, ErrorResponseException {
        if (StringUtils.isEmpty((CharSequence)bucket)) {
            bucket = this.defaultBucket;
        }
        GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(filePath)).build());
        return inputStream;
    }

    public void getObject(HttpServletResponse httpServletResponse, String filePath) throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, ErrorResponseException {
        String bucketName = "default";
        String fileName = FileTools.getFileName(filePath);
        GetObjectResponse inputStream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(filePath)).build());
        this.downloadFile(httpServletResponse, (InputStream)inputStream, fileName);
    }

    public String createFilePath(String originalFilename) {
        return new SimpleDateFormat("yyyy/MM/dd").format(new Date()) + "/" + originalFilename;
    }

    public String createFilePath(String fileCatalogue, String originalFilename) {
        return fileCatalogue + "/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date()) + "/" + originalFilename;
    }

    public void downloadFile(HttpServletResponse httpServletResponse, InputStream inputStream, String fileName) throws IOException {
        httpServletResponse.setContentType("application/octet-stream;charset=UTF-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream outputStream = httpServletResponse.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        outputStream.close();
    }

    public InputStream getFileInputStream(String filePath) {
        String bucketName = "default";
        GetObjectResponse stream = null;
        try {
            StatObjectResponse statObjectResponse = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(filePath)).build());
            if (statObjectResponse != null && statObjectResponse.size() > 0L) {
                stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(filePath)).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stream;
    }

    public InputStream getFileInputStreamByUrl(String filePath) {
        String bucketName = "default";
        InputStream stream = null;
        try {
            URL url = new URL(this.endpoint + "/" + bucketName + "/" + filePath);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            stream = connection.getInputStream();
        }
        catch (Exception e) {
            log.error("\u901a\u8fc7url\u83b7\u53d6\u6587\u4ef6\u6d41\u5f02\u5e38:" + e.getMessage());
        }
        return stream;
    }

    public void removeFile(String filePath) {
        String bucketName = "default";
        try {
            boolean res = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
            if (res) {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(filePath)).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

