package ${package.ServiceImpl};

import ${package.Entity}.${entity};
import ${package.Mapper}.${table.mapperName};
<#if table.serviceInterface>
    import ${package.Service}.${table.serviceName};
</#if>
import ${superServiceImplClassPackage};
import org.springframework.stereotype.Service;


import org.springframework.beans.factory.annotation.Autowired;
import java.util.Date;
import java.util.List;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResultJSON;
import org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

/**
* <p>
    * ${table.comment!} 服务实现类
    * </p>
*
* @author ${author}
* @since ${date}
*/
@Service
<#if kotlin>
    open class ${table.serviceImplName} : ${superServiceImplClass}<${table.mapperName}, ${entity}>()<#if table.serviceInterface>, ${table.serviceName}</#if> {

    }
<#else>
    public class ${table.serviceImplName} extends ${superServiceImplClass}<${table.mapperName}, ${entity}><#if table.serviceInterface> implements ${table.serviceName}</#if> {


    ResultJSON resultJSON;

    @Autowired
    ${table.mapperName} ${table.entityPath}Mapper;

    @Override
    public ResultJSON query(int page,int rows,String params){
    JSONObject jsonObject=JSON.parseObject(params);
    <#list queryList as item>
        <#if item.fieldType == 'varchar'||item.fieldType == 'VARCHAR2'||item.fieldType == 'VARCHAR'||item.fieldType == 'CHAR'>
            String ${item.prop} = jsonObject.getString("${item.prop}");
        <#elseif item.fieldType == 'int'||item.fieldType == 'INT'>
            int ${item.prop} = jsonObject.getInteger("${item.prop}");
        <#elseif item.fieldType == 'float'||item.fieldType == 'FLOAT'>
            float ${item.prop} = jsonObject.getInteger("${item.prop}");
        <#elseif item.fieldType == 'double'||item.fieldType == 'DOUBLE'>
            Double ${item.prop} = jsonObject.getDouble("${item.prop}");
        <#elseif item.fieldType == 'NUMBER'&& item.dataPrecision == 0>
            int ${item.prop} = jsonObject.getInteger("${item.prop}");
        <#elseif item.fieldType == 'NUMBER'&& item.dataPrecision != 0>
            Double ${item.prop} = jsonObject.getDouble("${item.prop}");
        <#elseif item.fieldType == 'date'||item.fieldType == 'datetime'||item.fieldType == 'DATE'||item.fieldType == 'DATETIME'||item.fieldType == 'TIMESTAMP'>
            <#if item.dateFlag=='1'>
                JSONArray ${item.prop}Range = jsonObject.getJSONArray("${item.prop}");
                Date ${item.prop}Begin = ${item.prop}Range.getDate(0);
                Date ${item.prop}End = ${item.prop}Range.getDate(1);
            <#else>
                Date ${item.prop} = jsonObject.getDate("${item.prop}");
            </#if>
        </#if>
    </#list>
    Page<${entity}> ${table.entityPath}Page=new Page<>(page,rows);
    QueryWrapper<${entity}>queryWrapper=new QueryWrapper<>();
    queryWrapper.eq("cancel_flag","0");
    <#list queryList as item>
        <#if item.fieldType == 'date'||item.fieldType == 'datetime'||item.fieldType == 'DATE'||item.fieldType == 'DATETIME'||item.fieldType == 'TIMESTAMP'>
            <#if item.dateFlag=='1'>
                queryWrapper.between(ObjectUtils.isNotEmpty(${item.prop}Begin),"${item.fieldName}",${item.prop}Begin, ${item.prop}End);
            <#else>
                queryWrapper.eq(ObjectUtils.isNotEmpty(${item.prop}),"${item.fieldName}",${item.prop});
            </#if>
        <#else>
            <#if item.fuzzyFlag == '1'>
                queryWrapper.like(StringUtils.isNotEmpty(${item.prop}),"${item.fieldName}",${item.prop});
            <#else>
                <#if item.fieldType == 'varchar'||item.fieldType == 'VARCHAR'||item.fieldType == 'VARCHAR2'||item.fieldType == 'char'||item.fieldType == 'CHAR'>
                    queryWrapper.eq(StringUtils.isNotEmpty(${item.prop}),"${item.fieldName}",${item.prop});
                <#else>
                    queryWrapper.eq(ObjectUtils.isNotEmpty(${item.prop}),"${item.fieldName}",${item.prop});
                </#if>
            </#if>
        </#if>
    </#list>
    queryWrapper.orderByDesc("add_time");
    Page<${entity}>list= ${table.entityPath}Mapper.selectPage(${table.entityPath}Page,queryWrapper);
    resultJSON=JSONTools.toResultJSON(list);
    return resultJSON;
    }

    @Override
    public ResultJSON queryByPK(String id) {
    ${entity} ${table.entityPath} =  ${table.entityPath}Mapper.selectByPK(id);
    resultJSON = JSONTools.toResultJSON(${table.entityPath});
    return resultJSON;
    }


    @Override
    public ResultJSON save(String userId,String json){
    Date date = new Date();
    ${entity} ${table.entityPath} =JSON.parseObject(json,new TypeReference<${entity}>(){
    });
    if(StringUtils.isEmpty(${table.entityPath}.getId())){
    ${table.entityPath}.setCancelFlag("0");
    ${table.entityPath}.setAddId(userId);
    ${table.entityPath}.setAddTime(date);
    ${table.entityPath}Mapper.insert(${table.entityPath});
    }else{
    ${table.entityPath}.setModifyId(userId);
    ${table.entityPath}.setModifyTime(date);
    ${table.entityPath}Mapper.updateById(${table.entityPath});
    }

    resultJSON=JSONTools.toResultJSON(${table.entityPath});
    return resultJSON;
    }

    @Override
    public ResultJSON remove(String userId,String id){
    Date date=new Date();
    ${entity} ${table.entityPath} = ${table.entityPath}Mapper.selectById(id);
    ${table.entityPath}.setCancelFlag("1");
    ${table.entityPath}.setCancelId(userId);
    ${table.entityPath}.setCancelTime(date);
    ${table.entityPath}Mapper.updateById(${table.entityPath});
    resultJSON=JSONTools.toResultJSON("");
    return resultJSON;
    }

    @Override
    public ResultJSON removeBatch(String userId, String ids) {
    Date date = new Date();
    ${r"List<String>"} list = JSON.parseObject(ids,new TypeReference<${r"List<String>"}>() {
    });
    ${entity} ${table.entityPath};
    for(String id :list){
    ${table.entityPath} = ${table.entityPath}Mapper.selectById(id);
    ${table.entityPath}.setCancelFlag("1");
    ${table.entityPath}.setCancelId(userId);
    ${table.entityPath}.setCancelTime(date);
    ${table.entityPath}Mapper.updateById(${table.entityPath});
    }
    resultJSON = JSONTools.toResultJSON("");
    return resultJSON;
    }

    }
</#if>
