-- Create table
create table  ${tableName}
(
<#list fields as field>
    <#if field.type?contains("VARCHAR")>
        <#if field.name=='ID'>
            ID VARCHAR2(32)  not null <#if field_has_next>,</#if>
        <#else>
        ${field.name} VARCHAR2(${field.length?c}) <#if field.nullable =='N'> not null </#if><#if field_has_next>,</#if>
        </#if>
    <#elseif field.type =='NUMBER'>
        ${field.name} ${field.type} <#if field.scale ==0> (${field.precision}) <#else> (${field.precision},${field.scale})</#if>  <#if field.nullable =='N'> not null </#if><#if field_has_next>,</#if>
    <#elseif field.type =='DATE'>
        ${field.name} DATE <#if field.nullable =='N'> not null </#if><#if field_has_next>,</#if>
    <#elseif field.type?contains("TIMESTAMP")>
        ${field.name} TIMESTAMP(6) <#if field.nullable =='N'> not null </#if><#if field_has_next>,</#if>
    <#else>
        该类型未匹配,手动添加
    </#if>
</#list>
)
tablespace   ${tableSpace}
pctfree 10
initrans 1
maxtrans 255
storage
(
initial 64K
next 8K
minextents 1
maxextents unlimited
);
-- Add comments to the columns
<#list fields as field>
    comment on column ${tableName}.${field.name}
    is '${field.comments}';
</#list>
-- Create/Recreate primary, unique and foreign key constraints
alter table ${tableName}
add constraint ${tableName}_PK primary key (ID)
using index
tablespace ${tableSpace}
pctfree 10
initrans 2
maxtrans 255
storage
(
initial 64K
next 1M
minextents 1
maxextents unlimited
);
