
CREATE TABLE ${tableName}
(
<#list fields as field>
    <#if field.type?contains("VARCHAR")>
        <#if field.name=='ID'>
${field.name} varchar(${field.length?c}) NOT NULL COMMENT '主键' ,
        <#elseif field.name=='KEY'>
`${field.name}` varchar(${field.length?c}) <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL </#if> COMMENT '${field.comments}' ,
        <#else>
${field.name} varchar(${field.length?c}) <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL </#if> COMMENT '${field.comments}' ,
        </#if>
    <#elseif field.type =='NUMBER'>
        <#if field.scale== 0>
${field.name} int(${field.precision})  <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL </#if> COMMENT '${field.comments}',
        <#else>
${field.name} double(${field.precision},${field.scale})  <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL </#if> COMMENT '${field.comments}',
        </#if>
    <#elseif field.type =='DATE'>
${field.name} date <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL  </#if> COMMENT '${field.comments}'  ,
    <#elseif field.type =='DATETIME'>
${field.name} datetime <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL  </#if> COMMENT '${field.comments}'  ,
    <#elseif field.type?contains("TIMESTAMP")>
${field.name} timestamp <#if field.nullable =='N'> NOT NULL<#else> DEFAULT NULL  </#if> COMMENT '${field.comments}'  ,
    <#else>
该类型未匹配,手动添加 ,
    </#if>
</#list>
PRIMARY KEY (ID) USING BTREE
)ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Compressed;