
CREATE TABLE "${username}"."${tableName}"
(
<#list fields as field>
    <#if field.type?contains("VARCHAR") || field.type?contains("varchar")>
"${field.name}" VARCHAR(${field.length?c}) <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type =='NUMBER'>
        "${field.name}" ${field.type} (${field.precision},${field.scale})  <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type =='int' || field.type =='INT'>
        "${field.name}" INT <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type =='float' || field.type =='FLOAT'>
        "${field.name}" FLOAT <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type =='double' || field.type =='DOUBLE'>
        "${field.name}" DOUBLE <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type =='DATE' || field.type?contains("datetime")>
        "${field.name}" DATETIME <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type?contains("TIMESTAMP")>
        "${field.name}" TIMESTAMP(0)  <#if field.nullable =='N'> NOT NULL </#if> ,
    <#elseif field.type?contains("text")>
        "${field.name}" TEXT  <#if field.nullable =='N'> NOT NULL </#if> ,
    <#else>
该类型未匹配,手动添加 ,
    </#if>
</#list>
UNIQUE("ID"),
NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "${tableSpace}", CLUSTERBTR) ;
<#list fields as field>
COMMENT ON COLUMN "${username}"."${tableName}"."${field.name}" IS '${field.comments}';
</#list>