-- drop table     ;
create table "${schema}"."${tableName}"
(
<#list fields as field>
    <#if field.fieldType =="VARCHAR" || field.fieldType =="CHAR">
        "${field.fieldName}" ${field.fieldType}(${field.dataLength?c}) <#if field.nullFlag  =="1">NOT NULL</#if>  ,
    <#elseif field.fieldType =="NUMBER">
        "${field.fieldName}" ${field.fieldType}(${field.dataLength?c},${field.dataPrecision?c})<#if field.nullFlag  =="1">NOT NULL</#if> ,
    <#elseif field.fieldType =="INT">
        "${field.fieldName}" ${field.fieldType}<#if field.nullFlag  =="1">NOT NULL</#if> ,
    <#elseif field.fieldType =="FLOAT">
        "${field.fieldName}" ${field.fieldType}<#if field.nullFlag  =="1">NOT NULL</#if> ,
    <#elseif field.fieldType =="DOUBLE">
        "${field.fieldName}" ${field.fieldType}<#if field.nullFlag  =="1">NOT NULL</#if> ,
    <#elseif field.fieldType =="DATETIME">
        "${field.fieldName}" ${field.fieldType}<#if field.nullFlag  =="1">NOT NULL</#if> ,
    <#elseif field.fieldType =="TIMESTAMP">
        "${field.fieldName}" ${field.fieldType}<#if field.nullFlag  =="1">NOT NULL</#if> ,
    </#if>
</#list>
UNIQUE("ID"),
NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "${tablespace}", CLUSTERBTR) ;

<#list fields as field>
    COMMENT ON COLUMN "${schema}"."${tableName}"."${field.fieldName}"  is '${field.fieldComment}';
</#list>