<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">
<mapper namespace="${package.Mapper}.${table.mapperName}">
    <resultMap id="BaseResultMap" type="${package.Entity}.${entity}">
        <#list table.fields as field>
            <#if field.keyFlag><#--生成主键排在第一位-->
                <id column="${field.name}" property="${field.propertyName}"  />
            </#if>
        </#list>
        <#list table.commonFields as field><#--生成公共字段 -->
            <result column="${field.name}" property="${field.propertyName}"  />
        </#list>
        <#list table.fields as field>
            <#if !field.keyFlag><#--生成普通字段 -->
                <result column="${field.name}" property="${field.propertyName}"  />
            </#if>
        </#list>
    </resultMap>

    <sql id="Base_Column_List">
        <#list table.commonFields as field>
            ${field.columnName},
        </#list>
        ${table.fieldNames}
    </sql>

    <select id="selectByPrimaryKey" resultMap="BaseResultMap" parameterType="java.lang.String" >
        select
        <include refid="Base_Column_List" />
        from  ${table.name}
        <#noparse>
            where ID = #{id,jdbcType=VARCHAR}
        </#noparse>
    </select>

    <delete id="deleteByPrimaryKey" parameterType="java.lang.String" >
        delete from  ${table.name}
        <#noparse>
            where ID = #{id,jdbcType=VARCHAR}
        </#noparse>
    </delete>


    <insert id="insert" parameterType="${package.Entity}.${entity}" >
        <selectKey keyProperty="id" order="BEFORE" resultType="java.lang.String" databaseId="oracle">
            SELECT sys_guid() as id from dual
        </selectKey>
        <selectKey keyProperty="id" order="BEFORE" resultType="java.lang.String" databaseId="mysql">
            SELECT REPLACE(UUID(),'-','') as id from dual
        </selectKey>
        <selectKey keyProperty="id" order="BEFORE" resultType="java.lang.String" databaseId="dameng">
    SELECT REPLACE(newid(),'-','') as id from dual
        </selectKey>
        insert into ${table.name} (
        <#list table.fields as field>
            ${field.name}<#sep>,
        </#list>
        )
        values (
        <#list table.fields as field>
            <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse><#sep>,
        </#list>
        )
    </insert>



    <update id="updateByPrimaryKey" parameterType="${package.Entity}.${entity}" >
        update ${table.name}
        set
        <#list table.fields as field>
            ${field.name} = <#noparse>#{</#noparse>${field.propertyName}<#noparse>}</#noparse><#sep>,
        </#list>
        where ID = <#noparse>#{id,jdbcType=VARCHAR}</#noparse>
    </update>


    <select id="selectForPopup" resultMap="BaseResultMap">
        select *  from ${table.name}
        where cancel_flag = '0'
        and belong_id   like concat('%',<#noparse>#{belongId}</#noparse>,'%')
        <#list table.fields as field>
            <#list cfg.querys as query>
                <#if field.name == query.fieldName>
                    <#if query.controllerType == "日期">
        <if test="${field.propertyName}Begin != null and ${field.propertyName}End != null">
            and  UNIX_TIMESTAMP(${field.name}) <#noparse>&gt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}Begin})
            and  UNIX_TIMESTAMP(${field.name}) <#noparse>&lt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}End})
        </if>
                    <#elseif query.controllerType == "日期时间">
        <if test="${field.propertyName}Begin != null and ${field.propertyName}End != null">
            and  UNIX_TIMESTAMP(${field.name}) <#noparse>&gt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}Begin})
            and  UNIX_TIMESTAMP(${field.name}) <#noparse>&lt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}End})
        </if>
                    <#else>
        <if test="${field.propertyName} != null and ${field.propertyName} !=''">
            and <#if query.fuzzyFlag == '1'>${field.name} like concat('%',<#noparse>#</#noparse>{${field.propertyName}},'%')<#else>${field.name} = <#noparse>#</#noparse>{${field.propertyName}}</#if>
        </if>
                    </#if>
                </#if>
            </#list>
        </#list>
    </select>


    <select id="selectByParam" resultMap="BaseResultMap">
        select *  from ${table.name}
        where cancel_flag = '0'
        and belong_id like concat('%',<#noparse>#{belongId}</#noparse>,'%')
        <#list table.fields as field>
            <#list cfg.querys as query>
                <#if field.name == query.fieldName>
                    <#if query.controllerType == "日期">
        <if test="${field.propertyName}Begin != null and ${field.propertyName}End != null">
        and  UNIX_TIMESTAMP(${field.name}) <#noparse>&gt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}Begin})
        and  UNIX_TIMESTAMP(${field.name}) <#noparse>&lt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}End})
        </if>
                     <#elseif query.controllerType == "日期时间">
        <if test="${field.propertyName}Begin != null and ${field.propertyName}End != null">
        and  UNIX_TIMESTAMP(${field.name}) <#noparse>&gt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}Begin})
        and  UNIX_TIMESTAMP(${field.name}) <#noparse>&lt;</#noparse> UNIX_TIMESTAMP(<#noparse>#</#noparse>{${field.propertyName}End})
        </if>
                    <#else>
        <if test="${field.propertyName} != null and ${field.propertyName} !=''">
        and <#if query.fuzzyFlag == '1'>${field.name} like  concat('%',<#noparse>#</#noparse>{${field.propertyName}},'%')<#else>${field.name} = <#noparse>#</#noparse>{${field.propertyName}}</#if>
        </if>
                    </#if>
                </#if>
            </#list>
        </#list>
        <choose>
            <when test="personalFlag != null and personalFlag =='1'">
                and ADD_ID = <#noparse>#</#noparse>{userId}
            </when>
            <otherwise>
                and ADD_DEPT_CODE in
                <foreach item="item" index="index" collection="departmentCodeList"
                         open="(" separator="," close=")">
                    <#noparse>#</#noparse>{item}
                </foreach>
            </otherwise>
        </choose>
    </select>
</mapper>
