/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator.tools;

import com.shinsoft.generator.Export;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Tools {
    public static String getDbType(String driver) throws Exception {
        String dbType = "";
        if (driver.contains("oracle")) {
            dbType = "oracle";
        } else if (driver.contains("mysql")) {
            dbType = "mysql";
        } else if (driver.contains("DmDriver")) {
            dbType = "dameng";
        } else {
            throw new Exception("\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u9a71\u52a8");
        }
        return dbType;
    }

    public static String getSchema(String username, String url, String driver) {
        String schema = "";
        System.out.println("getDBTYPE----------url:" + url);
        if (driver.toLowerCase().contains("mysql")) {
            if (url.contains("?")) {
                schema = url.split("\\?")[0];
            }
            schema = schema.split("/")[schema.split("/").length - 1];
        } else {
            schema = username;
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getConfig() {
        HashMap<String, String> map;
        block42: {
            InputStream input = null;
            map = new HashMap<String, String>();
            Properties properties = new Properties();
            try {
                String configFileName = "config.properties";
                File externalConfigFile = new File(configFileName);
                if (externalConfigFile.exists()) {
                    System.out.println("\u52a0\u8f7d JAR \u540c\u7ea7\u76ee\u5f55\u4e0b\u7684\u914d\u7f6e\u6587\u4ef6: " + externalConfigFile.getAbsolutePath());
                    try (FileInputStream fis = new FileInputStream(externalConfigFile);){
                        properties.load(fis);
                    }
                }
                System.out.println("\u52a0\u8f7d resources \u4e2d\u7684\u914d\u7f6e\u6587\u4ef6: " + configFileName);
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName);){
                    if (is == null) {
                        throw new FileNotFoundException("\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230: " + configFileName);
                    }
                    properties.load(is);
                }
                map.put("username", properties.getProperty("username"));
                map.put("password", properties.getProperty("password"));
                map.put("driver", properties.getProperty("driver"));
                map.put("url", properties.getProperty("url"));
                map.put("tablespace", properties.getProperty("tablespace"));
                map.put("tableSchema", properties.getProperty("tableSchema"));
                map.put("dbPath", properties.getProperty("dbPath"));
                if (properties.getProperty("driver").contains("oracle")) {
                    map.put("dbType", "oracle");
                    break block42;
                }
                if (properties.getProperty("driver").contains("mysql")) {
                    map.put("dbType", "mysql");
                    break block42;
                }
                if (properties.getProperty("driver").contains("DmDriver")) {
                    map.put("dbType", "dameng");
                    break block42;
                }
                throw new Exception("\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u9a71\u52a8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return map;
    }

    public static InputStream getInputStream(String fileName) {
        InputStream inputStream = null;
        File externalFile = new File("data/" + fileName);
        if (externalFile.exists()) {
            try {
                inputStream = new FileInputStream(externalFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            inputStream = FileReader.class.getClassLoader().getResourceAsStream("data/" + fileName);
        }
        return inputStream;
    }

    public static String getPath() {
        String path = Export.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (System.getProperty("os.name").contains("dows")) {
            path = path.substring(1, path.length());
        }
        if (path.contains("jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        return path;
    }

    public static InputStream replaceInInputStream(InputStream inputStream, String target, String replacement) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        String originalContent = stringBuilder.toString();
        String updatedContent = originalContent.replace(target, replacement);
        return new ByteArrayInputStream(updatedContent.getBytes(StandardCharsets.UTF_8));
    }
}

