/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator.tools;

import com.shinsoft.generator.tools.Tools;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLiteTools {
    public static String getInitDbPath() {
        if (SQLiteTools.isDevelopmentEnvironment()) {
            URL resource = SQLiteTools.class.getClassLoader().getResource("init.db");
            if (resource != null) {
                try {
                    return new File(resource.toURI()).getPath();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String jarPath = SQLiteTools.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            File jarFile = new File(jarPath);
            File initDbFile = new File(jarFile.getParent(), "init.db");
            if (initDbFile.exists()) {
                return initDbFile.getPath();
            }
        }
        return null;
    }

    public static String getDataSqlPath(String fileName) {
        if (SQLiteTools.isDevelopmentEnvironment()) {
            URL resource = SQLiteTools.class.getClassLoader().getResource("data/" + fileName);
            if (resource != null) {
                try {
                    return new File(resource.toURI()).getPath();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        } else {
            String jarPath = SQLiteTools.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            File jarFile = new File(jarPath);
            File initDbFile = new File(jarFile.getParent(), "data/" + fileName);
            if (initDbFile.exists()) {
                return initDbFile.getPath();
            }
        }
        return null;
    }

    public static boolean isDevelopmentEnvironment() {
        String classPath = System.getProperty("java.class.path");
        return classPath.contains(";") || classPath.contains(":");
    }

    public static Connection getConnection(String dbPath) throws SQLException {
        Connection connection = null;
        try {
            String dbUrl = "jdbc:sqlite:" + dbPath;
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection(dbUrl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    public static Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            Map<String, String> mapConfig = Tools.getConfig();
            String dbPath = mapConfig.get("dbPath");
            String dbUrl = "jdbc:sqlite:" + dbPath;
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection(dbUrl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    public static List<Map<String, Object>> executeQuery(String sql, Object ... params) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try (Connection connection = SQLiteTools.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    statement.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet resultSet = statement.executeQuery();){
                int columnCount = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = resultSet.getMetaData().getColumnName(i);
                        Object value = resultSet.getObject(i);
                        row.put(columnName, value);
                    }
                    resultList.add(row);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, Object>> executeQuery(Connection connection, String sql, Object ... params) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    statement.setObject(i + 1, params[i]);
                }
            }
            try (ResultSet resultSet = statement.executeQuery();){
                int columnCount = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = resultSet.getMetaData().getColumnName(i);
                        Object value = resultSet.getObject(i);
                        row.put(columnName, value);
                    }
                    resultList.add(row);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    /*
     * Exception decompiling
     */
    public static int executeUpdate(String sql, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int executeInsert(String sql, Object ... params) {
        int rowsAffected = 0;
        try (Connection connection = SQLiteTools.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            for (int i = 0; i < params.length; ++i) {
                statement.setObject(i + 1, params[i]);
            }
            rowsAffected = statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowsAffected;
    }

    public static int executeInsert(Connection connection, String sql, Object ... params) {
        int rowsAffected = 0;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (int i = 0; i < params.length; ++i) {
                statement.setObject(i + 1, params[i]);
            }
            rowsAffected = statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rowsAffected;
    }

    public static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

