/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.shinsoft.generator.mapper.LowCodeFieldMapper;
import com.shinsoft.generator.mapper.LowCodeFormItemMapper;
import com.shinsoft.generator.mapper.LowCodeFormMapper;
import com.shinsoft.generator.mapper.LowCodeMapper;
import com.shinsoft.generator.model.LowCode;
import com.shinsoft.generator.model.LowCodeDefault;
import com.shinsoft.generator.model.LowCodeField;
import com.shinsoft.generator.model.LowCodeForm;
import com.shinsoft.generator.model.LowCodeFormItem;
import com.shinsoft.generator.service.LowCodeService;
import com.shinsoft.tools.JSONTools;
import com.shinsoft.tools.model.common.ResponseCodeMsg;
import com.shinsoft.tools.model.common.ResultJSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LowCodeServiceImpl
implements LowCodeService {
    @Autowired
    public LowCodeMapper lowCodeMapper;
    @Autowired
    LowCodeFormMapper lowCodeFormMapper;
    @Autowired
    LowCodeFormItemMapper lowCodeFormItemMapper;
    @Autowired
    public LowCodeFieldMapper lowCodeFieldMapper;
    ResultJSON resultJSON;

    @Override
    public ResultJSON query(String userId, String tableName) {
        LowCode lowCode = this.lowCodeMapper.selectByTableName(tableName);
        if (lowCode == null) {
            this.resultJSON = JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)("\u8868\uff1a" + tableName + " \u65e0\u7ef4\u62a4\u4fe1\u606f"));
            return this.resultJSON;
        }
        if (CollectionUtils.isEmpty(lowCode.getFields())) {
            this.resultJSON = JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)("\u8868\uff1a" + tableName + " \u65e0\u7ef4\u62a4\u4fe1\u606f"));
            return this.resultJSON;
        }
        this.resultJSON = JSONTools.toResultJSON((Object)lowCode);
        return this.resultJSON;
    }

    @Override
    public ResultJSON queryDefault(String dbType) {
        List<LowCodeField> list = this.getDefaultField(dbType);
        this.resultJSON = JSONTools.toResultJSON(list);
        return this.resultJSON;
    }

    private List<LowCodeField> getDefaultField(String dbType) {
        ArrayList<LowCodeField> list = new ArrayList<LowCodeField>();
        String[] fn = LowCodeDefault.fn;
        String[] fc = LowCodeDefault.fc;
        String[] po = LowCodeDefault.po;
        for (int i = 0; i < fn.length; ++i) {
            LowCodeField lowCodeField = new LowCodeField();
            lowCodeField.setFieldName(fn[i]);
            lowCodeField.setFieldComment(fc[i]);
            lowCodeField.setProp(po[i]);
            lowCodeField.setLabel(fc[i]);
            if (fn[i].contains("TIME")) {
                lowCodeField.setWidth("160");
                if (dbType.equals("oracle")) {
                    lowCodeField.setFieldType("DATE");
                } else if (dbType.equals("mysql")) {
                    lowCodeField.setFieldType("datetime");
                } else if (dbType.equals("dmdriver")) {
                    lowCodeField.setFieldType("DATETIME");
                } else {
                    lowCodeField.setFieldType("DATE");
                }
                lowCodeField.setControllerType("\u65e5\u671f\u65f6\u95f4");
            } else {
                lowCodeField.setWidth("120");
                if (dbType.equals("oracle")) {
                    lowCodeField.setFieldType("VARCHAR2");
                } else if (dbType.equals("mysql")) {
                    lowCodeField.setFieldType("varchar");
                } else if (dbType.equals("dmdriver")) {
                    lowCodeField.setFieldType("VARCHAR");
                } else {
                    lowCodeField.setFieldType("VARCHAR2");
                }
                lowCodeField.setControllerType("\u5355\u884c\u6587\u672c");
            }
            if (fn[i].contains("ID")) {
                lowCodeField.setDataLength(32);
            } else {
                lowCodeField.setDataLength(50);
            }
            if (fn[i].equals("ID")) {
                lowCodeField.setNullFlag("1");
                lowCodeField.setPkFlag("1");
            } else {
                lowCodeField.setNullFlag("0");
                lowCodeField.setPkFlag("0");
            }
            lowCodeField.setSort(i + 1);
            lowCodeField.setDataPrecision(0);
            lowCodeField.setInputFlag("0");
            lowCodeField.setRequireFlag("0");
            lowCodeField.setQueryFlag("0");
            lowCodeField.setFuzzyFlag("0");
            lowCodeField.setDateFlag("0");
            lowCodeField.setShowFlag("0");
            lowCodeField.setHeaderAlign("center");
            lowCodeField.setAlign("center");
            lowCodeField.setFormatter("");
            lowCodeField.setSortable("0");
            lowCodeField.setColType("text");
            list.add(lowCodeField);
        }
        return list;
    }

    @Override
    public ResultJSON save(String userId, String form, String json) {
        List list = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<LowCodeField>>(){}, (Feature[])new Feature[0]);
        if (list.size() == 0) {
            this.resultJSON = JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)"\u65e0\u5b57\u6bb5\u4fe1\u606f,\u65e0\u6cd5\u4fdd\u5b58");
            return this.resultJSON;
        }
        LowCode lowCode = (LowCode)JSON.parseObject((String)form, (TypeReference)new TypeReference<LowCode>(){}, (Feature[])new Feature[0]);
        if (StringUtils.isEmpty((CharSequence)lowCode.getId())) {
            LowCode temp = this.lowCodeMapper.selectByTableName(lowCode.getTableName());
            if (temp != null) {
                this.resultJSON = JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)"\u8be5\u8868\u5df2\u7ef4\u62a4\uff0c\u8bf7\u67e5\u8be2");
                return this.resultJSON;
            }
            this.lowCodeMapper.insert(lowCode);
        } else {
            this.lowCodeMapper.updateByPrimaryKey(lowCode);
        }
        for (int i = 0; i < list.size(); ++i) {
            LowCodeField lowCodeField = (LowCodeField)list.get(i);
            if (StringUtils.isEmpty((CharSequence)lowCodeField.getId())) {
                lowCodeField.setFId(lowCode.getId());
                lowCodeField.setSort(i + 1);
                if (lowCodeField.getFieldType().equals("VARCHAR2") || lowCodeField.getFieldType().equals("varchar")) {
                    lowCodeField.setControllerType("\u5355\u884c\u6587\u672c");
                    lowCodeField.setAlign("center");
                } else if (lowCodeField.getFieldType().equals("NUMBER") || lowCodeField.getFieldType().equals("int") || lowCodeField.getFieldType().equals("float") || lowCodeField.getFieldType().equals("double")) {
                    lowCodeField.setControllerType("\u5355\u884c\u6587\u672c");
                    lowCodeField.setAlign("right");
                } else if (lowCodeField.getFieldType().equals("DATE") || lowCodeField.getFieldType().equals("datetime")) {
                    lowCodeField.setControllerType("\u65e5\u671f\u65f6\u95f4");
                    lowCodeField.setAlign("center");
                } else if (lowCodeField.getFieldType().equals("date")) {
                    lowCodeField.setControllerType("\u65e5\u671f");
                    lowCodeField.setAlign("center");
                } else {
                    lowCodeField.setControllerType("\u5355\u884c\u6587\u672c");
                    lowCodeField.setAlign("center");
                }
                lowCodeField.setWidth(lowCodeField.getFieldComment().length() * 60 + "");
                lowCodeField.setLabel(lowCodeField.getFieldComment());
                lowCodeField.setInputFlag("0");
                lowCodeField.setRequireFlag("0");
                lowCodeField.setQueryFlag("0");
                lowCodeField.setFuzzyFlag("0");
                lowCodeField.setDateFlag("0");
                lowCodeField.setShowFlag("0");
                lowCodeField.setExportFlag("1");
                lowCodeField.setHeaderAlign("center");
                lowCodeField.setFormatter("");
                lowCodeField.setSortable("0");
                lowCodeField.setColType("text");
                this.lowCodeFieldMapper.insert(lowCodeField);
                continue;
            }
            lowCodeField.setSort(i + 1);
            this.lowCodeFieldMapper.updateByPrimaryKey(lowCodeField);
        }
        this.resultJSON = JSONTools.toResultJSON((Object)list);
        return this.resultJSON;
    }

    @Override
    public ResultJSON update(String userId, String form, String json) {
        LowCode lowCode = (LowCode)JSON.parseObject((String)form, (TypeReference)new TypeReference<LowCode>(){}, (Feature[])new Feature[0]);
        this.lowCodeMapper.updateByPrimaryKey(lowCode);
        if (lowCode.getFields().size() == 0) {
            this.resultJSON = JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)"\u65e0\u5b57\u6bb5\u4fe1\u606f,\u65e0\u6cd5\u4fdd\u5b58");
            return this.resultJSON;
        }
        for (int i = 0; i < lowCode.getFields().size(); ++i) {
            LowCodeField lowCodeField = lowCode.getFields().get(i);
            lowCodeField.setSort(i + 1);
            this.lowCodeFieldMapper.updateByPrimaryKey(lowCodeField);
        }
        this.resultJSON = JSONTools.toResultJSON((Object)lowCode);
        return this.resultJSON;
    }

    @Override
    public ResultJSON remove(String id) {
        this.lowCodeFieldMapper.deleteByPrimaryKey(id);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON saveForm(String json) {
        LowCodeForm lowCodeForm = (LowCodeForm)JSON.parseObject((String)json, (TypeReference)new TypeReference<LowCodeForm>(){}, (Feature[])new Feature[0]);
        this.lowCodeFormMapper.insertOrUpdate(lowCodeForm);
        this.resultJSON = JSONTools.toResultJSON((Object)lowCodeForm);
        return this.resultJSON;
    }

    @Override
    public ResultJSON removeForm(String id) {
        this.lowCodeFormMapper.deleteById((Serializable)((Object)id));
        this.resultJSON = JSONTools.toResultJSON((Object)id);
        return this.resultJSON;
    }

    @Override
    public ResultJSON queryForm(String menuId, String formName, String formType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"menu_id", (Object)menuId);
        queryWrapper.eq((Object)"form_name", (Object)formName);
        queryWrapper.eq((Object)"form_type", (Object)formType);
        LowCodeForm lowCodeForm = (LowCodeForm)this.lowCodeFormMapper.selectOne((Wrapper)queryWrapper);
        this.resultJSON = JSONTools.toResultJSON((Object)lowCodeForm);
        return this.resultJSON;
    }

    @Override
    public ResultJSON queryFormList(String menuId, String formType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"menu_id", (Object)menuId);
        queryWrapper.eq((Object)"form_type", (Object)formType);
        List list = this.lowCodeFormMapper.selectList((Wrapper)queryWrapper);
        this.resultJSON = JSONTools.toResultJSON((Object)list);
        return this.resultJSON;
    }

    @Override
    public ResultJSON queryFormItem(String menuId, String formType, String formName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)menuId), (Object)"MENU_ID", (Object)menuId);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)formType), (Object)"FORM_TYPE", (Object)formType);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)formName), (Object)"FORM_NAME", (Object)formName);
        queryWrapper.orderByAsc((Object)"sort");
        List list = this.lowCodeFormItemMapper.selectList((Wrapper)queryWrapper);
        this.resultJSON = JSONTools.toResultJSON((Object)list);
        return this.resultJSON;
    }

    @Override
    public ResultJSON saveFormItem(String userId, String json) {
        Date date = new Date();
        List list = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<LowCodeFormItem>>(){}, (Feature[])new Feature[0]);
        if (CollectionUtil.isEmpty((Collection)list)) {
            this.resultJSON = JSONTools.toResultJSON((int)ResponseCodeMsg.CODE_EX, (String)"\u65e0\u8868\u5355\u4fe1\u606f");
            return this.resultJSON;
        }
        String menuId = ((LowCodeFormItem)list.get(0)).getMenuId();
        String formType = ((LowCodeFormItem)list.get(0)).getFormType();
        String formName = ((LowCodeFormItem)list.get(0)).getFormName();
        this.lowCodeFormItemMapper.deleteByMenuIdFormTypeName(menuId, formType, formName);
        this.lowCodeFormItemMapper.insert(list);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON updateLowCodeByPK(String json) {
        LowCode lowCode = (LowCode)JSON.parseObject((String)json, (TypeReference)new TypeReference<LowCode>(){}, (Feature[])new Feature[0]);
        this.lowCodeMapper.updateByPrimaryKey(lowCode);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }

    @Override
    public ResultJSON updateLowCodeFieldByPK(String json) {
        LowCodeField lowCodeField = (LowCodeField)JSON.parseObject((String)json, (TypeReference)new TypeReference<LowCodeField>(){}, (Feature[])new Feature[0]);
        this.lowCodeFieldMapper.updateByPrimaryKey(lowCodeField);
        this.resultJSON = JSONTools.toResultJSON((Object)"");
        return this.resultJSON;
    }
}

