/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator.Transfer;

import cn.hutool.core.date.DateUtil;
import com.shinsoft.generator.Create;
import com.shinsoft.generator.Transfer.DbWindow;
import com.shinsoft.generator.tools.SQLTools;
import com.shinsoft.generator.tools.SQLiteTools;
import com.shinsoft.generator.tools.Tools;
import com.shinsoft.tools.DBTools;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;

public class Main
extends Application {
    private TextField tableNameField;
    private Button saveButton;
    private Button maintainDatabaseButton;
    private ComboBox<String> exportDbTypeComboBox;
    private TextField exportUsernameField;
    private PasswordField exportPasswordField;
    private TextField exportConnectionStringField;
    private TextField exportDriverField;
    private TextField exportTableSpaceField;
    private TextField exportSchemaField;
    private Button exportTestButton;
    private ComboBox<String> importDbTypeComboBox;
    private TextField importUsernameField;
    private PasswordField importPasswordField;
    private TextField importConnectionStringField;
    private TextField importDriverField;
    private TextField importTableSpaceField;
    private TextField importSchemaField;
    private Button importTestButton;
    private CheckBox includeDataCheckbox;
    private CheckBox includeStructureCheckbox;
    private TextArea sqlTextArea;
    private TextArea realTimeTextArea;

    public void start(Stage primaryStage) {
        primaryStage.setTitle("\u6570\u636e\u5e93\u8fc1\u79fb\u5de5\u5177");
        VBox exportPanel = this.createExportPanel();
        VBox importPanel = this.createImportPanel();
        VBox settingPanel = this.createSettingPanel();
        VBox transPanel = this.createTransPanel();
        SplitPane splitPane = new SplitPane();
        splitPane.getItems().addAll((Object[])new Node[]{exportPanel, importPanel});
        splitPane.setDividerPositions(new double[]{0.5});
        BorderPane leftLayout = new BorderPane();
        leftLayout.setCenter((Node)splitPane);
        leftLayout.setBottom((Node)settingPanel);
        BorderPane mainLayout = new BorderPane();
        mainLayout.setLeft((Node)leftLayout);
        mainLayout.setRight((Node)transPanel);
        mainLayout.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        Scene scene = new Scene((Parent)mainLayout, 1200.0, 900.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private VBox createSettingPanel() {
        VBox bottomPanel = new VBox(15.0);
        bottomPanel.setPadding(new Insets(15.0));
        bottomPanel.setPrefWidth(400.0);
        HBox checkPannel = new HBox();
        this.includeStructureCheckbox = new CheckBox("\u8868\u7ed3\u6784");
        this.includeStructureCheckbox.setSelected(true);
        this.includeDataCheckbox = new CheckBox("\u6570\u636e");
        this.includeDataCheckbox.setSelected(true);
        checkPannel.getChildren().addAll((Object[])new Node[]{this.includeStructureCheckbox, this.includeDataCheckbox});
        Label sqlLabel = new Label("SQL:");
        this.sqlTextArea = new TextArea();
        this.sqlTextArea.setPrefRowCount(3);
        this.sqlTextArea.setPromptText("\u8f93\u5165\u53ef\u9009\u7684SQL\u67e5\u8be2\u8bed\u53e5\uff08\u7528\u4e8e\u5bfc\u51fa\uff09");
        this.sqlTextArea.setText("select * from t_transfer_mysql");
        bottomPanel.getChildren().addAll((Object[])new Node[]{checkPannel, sqlLabel, this.sqlTextArea});
        return bottomPanel;
    }

    private VBox createTransPanel() {
        VBox panel = new VBox(15.0);
        panel.setPadding(new Insets(15.0));
        panel.setPrefWidth(400.0);
        this.tableNameField = new TextField();
        this.tableNameField.setPromptText("\u8f93\u5165\u8868\u540d");
        this.tableNameField.setText("t_transfer_mysql");
        Button migrateButton = new Button("\u5f00\u59cb\u8fc1\u79fb");
        migrateButton.setPrefWidth(150.0);
        migrateButton.setOnAction(e -> {
            try {
                this.handleMigration();
            }
            catch (Exception ex) {
                this.updateRealTimeText(ex.getMessage());
                throw new RuntimeException(ex);
            }
        });
        this.realTimeTextArea = new TextArea();
        this.realTimeTextArea.setPrefHeight(800.0);
        panel.getChildren().addAll((Object[])new Node[]{new Label("\u8bf7\u8f93\u5165\u8868\u540d\uff1a"), this.tableNameField, migrateButton, this.realTimeTextArea});
        return panel;
    }

    private VBox createExportPanel() {
        VBox panel = new VBox(15.0);
        panel.setPadding(new Insets(15.0));
        panel.setPrefWidth(400.0);
        Label titleLabel = new Label("\u5bfc\u51fa\u8bbe\u7f6e");
        titleLabel.setStyle("-fx-font-size: 16px; -fx-font-weight: bold;");
        Label dbTypeLabel = new Label("\u6570\u636e\u5e93\u7c7b\u578b:");
        this.exportDbTypeComboBox = new ComboBox();
        this.exportDbTypeComboBox.getItems().addAll((Object[])new String[]{"mysql", "oracle", "dameng"});
        this.exportDbTypeComboBox.setValue((Object)"");
        this.exportDbTypeComboBox.setOnAction(e -> this.handleExportDbTypeChange());
        this.exportTestButton = new Button("\u6d4b\u8bd5\u8fde\u63a5");
        this.exportTestButton.setOnAction(e -> {
            try {
                this.handleExportTestConnection();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
        Label usernameLabel = new Label("\u7528\u6237\u540d:");
        this.exportUsernameField = new TextField();
        this.exportUsernameField.setPromptText("\u8f93\u5165\u7528\u6237\u540d");
        Label passwordLabel = new Label("\u5bc6\u7801:");
        this.exportPasswordField = new PasswordField();
        this.exportPasswordField.setPromptText("\u8f93\u5165\u5bc6\u7801");
        Label connectionStringLabel = new Label("\u8fde\u63a5\u5b57\u7b26\u4e32:");
        this.exportConnectionStringField = new TextField();
        this.exportConnectionStringField.setPromptText("\u8f93\u5165JDBC\u8fde\u63a5\u5b57\u7b26\u4e32");
        Label driverLabel = new Label("\u9a71\u52a8\u7c7b\u540d:");
        this.exportDriverField = new TextField();
        this.exportDriverField.setPromptText("\u8f93\u5165JDBC\u9a71\u52a8\u7c7b\u540d");
        Label tableSpaceLabel = new Label("\u8868\u7a7a\u95f4:");
        this.exportTableSpaceField = new TextField();
        this.exportTableSpaceField.setPromptText("\u8f93\u5165\u8868\u7a7a\u95f4\u540d\u79f0");
        this.exportTableSpaceField.setDisable(true);
        Label schemaLabel = new Label("schema:");
        this.exportSchemaField = new TextField();
        this.exportSchemaField.setPromptText("\u8f93\u5165schema");
        this.exportSchemaField.setDisable(true);
        panel.getChildren().addAll((Object[])new Node[]{titleLabel, dbTypeLabel, this.exportDbTypeComboBox, usernameLabel, this.exportUsernameField, passwordLabel, this.exportPasswordField, connectionStringLabel, this.exportConnectionStringField, driverLabel, this.exportDriverField, tableSpaceLabel, this.exportTableSpaceField, schemaLabel, this.exportSchemaField, this.exportTestButton});
        return panel;
    }

    private void handleExportTestConnection() throws SQLException {
        String schema = Tools.getSchema(this.exportUsernameField.getText(), this.exportConnectionStringField.getText(), this.exportDriverField.getText());
        this.exportSchemaField.setText(schema);
        Connection connection = DBTools.getConnection((String)this.exportDriverField.getText(), (String)this.exportConnectionStringField.getText(), (String)this.exportUsernameField.getText(), (String)this.exportPasswordField.getText());
        if (connection != null) {
            connection.close();
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("\u63d0\u793a");
            alert.setHeaderText("\u8fde\u63a5\u6210\u529f");
            alert.setContentText("\u8fde\u63a5\u76ee\u6807\u6570\u636e\u5e93\u6210\u529f\u3002");
            alert.showAndWait();
        } else {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("\u9519\u8bef\u63d0\u793a");
            alert.setHeaderText("\u8fde\u63a5\u5931\u8d25");
            alert.setContentText("\u65e0\u6cd5\u8fde\u63a5\u76ee\u6807\u6570\u636e\u5e93\u3002");
            alert.showAndWait();
        }
    }

    private void handleImportTestConnection() throws SQLException {
        String schema = Tools.getSchema(this.importUsernameField.getText(), this.importConnectionStringField.getText(), this.importDriverField.getText());
        this.importSchemaField.setText(schema);
        Connection connection = DBTools.getConnection((String)this.importDriverField.getText(), (String)this.importConnectionStringField.getText(), (String)this.importUsernameField.getText(), (String)this.importPasswordField.getText());
        if (connection != null) {
            connection.close();
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("\u63d0\u793a");
            alert.setHeaderText("\u8fde\u63a5\u6210\u529f");
            alert.setContentText("\u8fde\u63a5\u76ee\u6807\u6570\u636e\u5e93\u6210\u529f\u3002");
            alert.showAndWait();
        } else {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("\u9519\u8bef\u63d0\u793a");
            alert.setHeaderText("\u8fde\u63a5\u5931\u8d25");
            alert.setContentText("\u65e0\u6cd5\u8fde\u63a5\u76ee\u6807\u6570\u636e\u5e93\u3002");
            alert.showAndWait();
        }
    }

    private void handleExportDbTypeChange() {
        if (((String)this.exportDbTypeComboBox.getValue()).equals("mysql")) {
            this.exportDriverField.setText("com.mysql.cj.jdbc.Driver");
            this.exportTableSpaceField.setDisable(true);
            this.exportUsernameField.setText("root");
            this.exportPasswordField.setText("root");
            this.exportConnectionStringField.setText("jdbc:mysql://localhost:3306/ai?characterEncoding=UTF-8");
        } else if (((String)this.exportDbTypeComboBox.getValue()).equals("oracle")) {
            this.exportDriverField.setText("oracle.jdbc.driver.OracleDriver");
            this.exportUsernameField.setText("smartoffice");
            this.exportPasswordField.setText("smartoffice");
            this.exportConnectionStringField.setText("jdbc:oracle:thin:@10.18.11.37:1521:smartoffice");
        } else if (((String)this.exportDbTypeComboBox.getValue()).equals("dameng")) {
            this.exportDriverField.setText("dm.jdbc.driver.DmDriver");
            this.exportUsernameField.setText("SHINDI");
            this.exportPasswordField.setText("SXxxjsgs2025");
            this.exportConnectionStringField.setText("jdbc:dm://10.19.13.211:5236");
        }
    }

    private void handleImportDbTypeChange() {
        if (((String)this.importDbTypeComboBox.getValue()).equals("mysql")) {
            this.importDriverField.setText("com.mysql.cj.jdbc.Driver");
            this.importTableSpaceField.setDisable(true);
            this.importUsernameField.setText("root");
            this.importPasswordField.setText("root");
            this.importConnectionStringField.setText("jdbc:mysql://localhost:3306/ai?characterEncoding=UTF-8");
        } else if (((String)this.importDbTypeComboBox.getValue()).equals("oracle")) {
            this.importDriverField.setText("oracle.jdbc.driver.OracleDriver");
            this.importUsernameField.setText("JLOPAPUSER");
            this.importPasswordField.setText("qVOGgL_f");
            this.importConnectionStringField.setText("jdbc:oracle:thin:@47.115.211.214:1521/JLOPDEV01");
            this.importTableSpaceField.setText("TS_MAIN_DAT");
        } else if (((String)this.importDbTypeComboBox.getValue()).equals("dameng")) {
            this.importDriverField.setText("dm.jdbc.driver.DmDriver");
            this.importUsernameField.setText("SHINDI");
            this.importPasswordField.setText("SXxxjsgs2025");
            this.importConnectionStringField.setText("jdbc:dm://10.19.13.211:5236");
            this.importTableSpaceField.setText("TBS_SHINDI");
        }
    }

    private VBox createImportPanel() {
        VBox panel = new VBox(15.0);
        panel.setPadding(new Insets(15.0));
        panel.setPrefWidth(400.0);
        Label titleLabel = new Label("\u5bfc\u5165\u8bbe\u7f6e");
        titleLabel.setStyle("-fx-font-size: 16px; -fx-font-weight: bold;");
        Label dbTypeLabel = new Label("\u6570\u636e\u5e93\u7c7b\u578b:");
        this.importDbTypeComboBox = new ComboBox();
        this.importDbTypeComboBox.getItems().addAll((Object[])new String[]{"mysql", "oracle", "dameng"});
        this.importDbTypeComboBox.setValue((Object)"");
        this.importDbTypeComboBox.setOnAction(e -> this.handleImportDbTypeChange());
        this.importTestButton = new Button("\u6d4b\u8bd5\u8fde\u63a5");
        this.importTestButton.setOnAction(e -> {
            try {
                this.handleImportTestConnection();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
        Label usernameLabel = new Label("\u7528\u6237\u540d:");
        this.importUsernameField = new TextField();
        this.importUsernameField.setPromptText("\u8f93\u5165\u7528\u6237\u540d");
        Label passwordLabel = new Label("\u5bc6\u7801:");
        this.importPasswordField = new PasswordField();
        this.importPasswordField.setPromptText("\u8f93\u5165\u5bc6\u7801");
        Label connectionStringLabel = new Label("\u8fde\u63a5\u5b57\u7b26\u4e32:");
        this.importConnectionStringField = new TextField();
        this.importConnectionStringField.setPromptText("\u8f93\u5165JDBC\u8fde\u63a5\u5b57\u7b26\u4e32");
        Label driverLabel = new Label("\u9a71\u52a8\u7c7b\u540d:");
        this.importDriverField = new TextField();
        this.importDriverField.setPromptText("\u8f93\u5165JDBC\u9a71\u52a8\u7c7b\u540d");
        Label tableSpaceLabel = new Label("\u8868\u7a7a\u95f4:");
        this.importTableSpaceField = new TextField();
        this.importTableSpaceField.setPromptText("\u8f93\u5165\u8868\u7a7a\u95f4\u540d\u79f0");
        Label schemaLabel = new Label("schema:");
        this.importSchemaField = new TextField();
        this.importSchemaField.setPromptText("\u8f93\u5165schema");
        this.importSchemaField.setDisable(true);
        panel.getChildren().addAll((Object[])new Node[]{titleLabel, dbTypeLabel, this.importDbTypeComboBox, usernameLabel, this.importUsernameField, passwordLabel, this.importPasswordField, connectionStringLabel, this.importConnectionStringField, driverLabel, this.importDriverField, tableSpaceLabel, this.importTableSpaceField, schemaLabel, this.importSchemaField, this.importTestButton});
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMigration() throws Exception {
        String sqlPath;
        Connection connection;
        String tableName;
        String importDriver;
        String importConnectionString;
        String importPassword;
        String importUsername;
        String importDbType;
        block164: {
            PrintWriter writer = null;
            this.realTimeTextArea.setText("");
            String exportDbType = (String)this.exportDbTypeComboBox.getValue();
            String exportUsername = this.exportUsernameField.getText();
            String exportPassword = this.exportPasswordField.getText();
            String exportConnectionString = this.exportConnectionStringField.getText();
            String exportDriver = this.exportDriverField.getText();
            String exportSchema = this.exportSchemaField.getText();
            String exportTableSpace = this.exportTableSpaceField.getText();
            importDbType = (String)this.importDbTypeComboBox.getValue();
            importUsername = this.importUsernameField.getText();
            importPassword = this.importPasswordField.getText();
            importConnectionString = this.importConnectionStringField.getText();
            importDriver = this.importDriverField.getText();
            String importSchema = this.importSchemaField.getText();
            String importTableSpace = this.importTableSpaceField.getText();
            boolean includeData = this.includeDataCheckbox.isSelected();
            String dataSql = this.sqlTextArea.getText();
            tableName = this.tableNameField.getText();
            this.updateRealTimeText("=== \u5bfc\u51fa\u8bbe\u7f6e ===");
            this.updateRealTimeText("\u6570\u636e\u5e93\u7c7b\u578b: " + exportDbType);
            this.updateRealTimeText("\u7528\u6237\u540d: " + exportUsername);
            this.updateRealTimeText("\u5bc6\u7801: " + (exportPassword.isEmpty() ? "\u672a\u8bbe\u7f6e" : "******"));
            this.updateRealTimeText("\u8fde\u63a5\u5b57\u7b26\u4e32: " + exportConnectionString);
            this.updateRealTimeText("\u9a71\u52a8\u7c7b\u540d: " + exportDriver);
            this.updateRealTimeText("\u8868\u7a7a\u95f4: " + exportSchema);
            this.updateRealTimeText("\n=== \u5bfc\u5165\u8bbe\u7f6e ===");
            this.updateRealTimeText("\u6570\u636e\u5e93\u7c7b\u578b: " + importDbType);
            this.updateRealTimeText("\u7528\u6237\u540d: " + importUsername);
            this.updateRealTimeText("\u5bc6\u7801: " + (importPassword.isEmpty() ? "\u672a\u8bbe\u7f6e" : "******"));
            this.updateRealTimeText("\u8fde\u63a5\u5b57\u7b26\u4e32: " + importConnectionString);
            this.updateRealTimeText("\u9a71\u52a8\u7c7b\u540d: " + importDriver);
            this.updateRealTimeText("\u8868\u7a7a\u95f4: " + importSchema);
            this.updateRealTimeText("\n=== \u8fc1\u79fb\u9009\u9879 ===");
            this.updateRealTimeText("\u5305\u542b\u6570\u636e: " + includeData);
            this.updateRealTimeText("SQL: " + (dataSql.isEmpty() ? "\u672a\u8bbe\u7f6e" : dataSql));
            this.updateRealTimeText("\n\u5f00\u59cb\u6267\u884c\u6570\u636e\u5e93\u8fc1\u79fb...");
            String sqlTableExist = "";
            if (exportDbType.equals("oracle")) {
                sqlTableExist = "select * from all_tables where table_name = upper('" + tableName + "') and  owner = upper('" + exportUsername + "')";
            } else if (exportDbType.equals("mysql")) {
                sqlTableExist = " SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema = '" + exportSchema + "' and table_name='" + tableName + "'; ";
            } else if (exportDbType.equals("dameng")) {
                sqlTableExist = "SELECT OWNER, TABLE_NAME FROM ALL_TABLES WHERE OWNER = '" + exportUsername.toUpperCase() + "' and TABLE_NAME = '" + tableName.toUpperCase() + "';";
            }
            this.updateRealTimeText("sqlTableExist--------" + sqlTableExist);
            connection = DBTools.getConnection((String)exportDriver, (String)exportConnectionString, (String)exportUsername, (String)exportPassword);
            List re = DBTools.executeQuery((Connection)connection, (String)sqlTableExist, null);
            if (re == null || re.size() == 0) {
                this.updateRealTimeText("\u672a\u627e\u5230\u8868");
                return;
            }
            String sqlCols = "";
            connection = DBTools.getConnection((String)exportDriver, (String)exportConnectionString, (String)exportUsername, (String)exportPassword);
            if (exportDbType.equals("oracle")) {
                sqlCols = SQLTools.getColsSqlOracle(exportUsername, tableName);
            } else if (exportDbType.equals("mysql")) {
                sqlCols = SQLTools.getColsSqlMysql(exportSchema, tableName);
            } else if (exportDbType.equals("dameng")) {
                sqlCols = SQLTools.getColsSqlDameng(exportUsername, tableName);
            }
            this.updateRealTimeText("sqlCols--------" + sqlCols);
            List cols = DBTools.executeQuery((Connection)connection, (String)sqlCols, null);
            if (cols == null || cols.size() == 0) {
                this.updateRealTimeText("\u8868\u65e0\u5b57\u6bb5");
                return;
            }
            this.updateRealTimeText("\u5220\u9664\u5df2\u5b58\u5728\u7684\u8868\u7ed3\u6784");
            String sql = " DROP TABLE IF EXISTS " + tableName + " ;";
            String initDbPath = "D:\\workspaces\\sgiip\\generator-db\\init.db";
            this.updateRealTimeText("initDbPath------" + initDbPath + "\n");
            Connection sqliteConnect = SQLiteTools.getConnection(initDbPath);
            if (sqliteConnect == null) {
                this.updateRealTimeText("\u8fde\u63a5sqlite\u5931\u8d25\n");
            }
            SQLiteTools.executeInsert(sqliteConnect, sql, new Object[0]);
            this.updateRealTimeText("\u521b\u5efa\u65b0\u7684\u8868\u7ed3\u6784");
            sql = " CREATE TABLE IF NOT EXISTS " + tableName + " (\n" + "    fieldName TEXT  ,\n" + "    fieldType TEXT  ,\n" + "    dataLength INTEGER  ,\n" + "    dataPrecision INTEGER  ,\n" + "    dataScale INTEGER  ,\n" + "    fieldComment TEXT  ,\n" + "    nullFlag TEXT  ,\n" + "    memo TEXT  \n" + ");  ";
            SQLiteTools.executeInsert(sqliteConnect, sql, new Object[0]);
            this.updateRealTimeText("\u5f00\u59cb\u63d2\u5165\u5b57\u6bb5");
            for (int i = 0; i < cols.size(); ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                Map col = (Map)cols.get(i);
                this.updateRealTimeText("\u5f00\u59cb\u63d2\u5165\u5b57\u6bb5------" + col.get("COLUMN_NAME").toString().toUpperCase());
                stringBuilder.append("insert into  " + tableName + " values (");
                stringBuilder.append("'" + col.get("COLUMN_NAME").toString().toUpperCase() + "'").append(",");
                stringBuilder.append("'" + col.get("DATA_TYPE").toString() + "'").append(",");
                if (col.get("DATA_LENGTH") != null) {
                    stringBuilder.append(Integer.parseInt(col.get("DATA_LENGTH").toString())).append(",");
                } else {
                    stringBuilder.append(0).append(",");
                }
                if (col.get("DATA_PRECISION") != null) {
                    stringBuilder.append(Integer.parseInt(col.get("DATA_PRECISION").toString())).append(",");
                } else {
                    stringBuilder.append(0).append(",");
                }
                if (col.get("DATA_SCALE") != null) {
                    stringBuilder.append(Integer.parseInt(col.get("DATA_SCALE").toString())).append(",");
                } else {
                    stringBuilder.append(0).append(",");
                }
                if (col.get("COMMENTS") != null) {
                    stringBuilder.append("'" + col.get("COMMENTS").toString() + "'").append(",");
                } else {
                    stringBuilder.append("''").append(",");
                }
                if (col.get("NULLABLE") != null) {
                    stringBuilder.append("'" + col.get("NULLABLE").toString() + "'").append(",");
                } else {
                    stringBuilder.append("'1'").append(",");
                }
                stringBuilder.append("''");
                stringBuilder.append(")");
                sql = stringBuilder.toString();
                this.updateRealTimeText(sql);
                int successCount = SQLiteTools.executeInsert(sqliteConnect, sql, new Object[0]);
                this.updateRealTimeText("\u6210\u529f\u6761\u6570:" + successCount);
            }
            if (StringUtils.isEmpty((CharSequence)dataSql)) {
                this.updateRealTimeText("\u65e0sql\u8bed\u53e5\uff0c\u4e0d\u5bfc\u51fa\u6570\u636e\n");
            } else {
                this.updateRealTimeText("\u5f00\u59cb\u5bfc\u51fa\u6570\u636e\n");
                this.updateRealTimeText("\u5bfc\u51fa\u6570\u636esql------" + dataSql + "\n");
                connection = DBTools.getConnection((String)exportDriver, (String)exportConnectionString, (String)exportUsername, (String)exportPassword);
                re = DBTools.executeQuery((Connection)connection, (String)dataSql, null);
                String exportFilePath = Tools.getPath() + "data";
                File file = new File(exportFilePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                writer = new PrintWriter(exportFilePath + File.separator + tableName + ".sql", "utf-8");
                for (int i = 0; i < re.size(); ++i) {
                    Map map = (Map)re.get(i);
                    String sqlInsert = "";
                    String columns = "";
                    String values = "";
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        String finalKey = key;
                        Object v = cols.stream().filter(m -> m.get("COLUMN_NAME").toString().equals(finalKey)).findFirst().get().get("DATA_TYPE");
                        if (value == null) continue;
                        columns = columns + key + ",";
                        if ("oracle".equals(importDbType)) {
                            if ("DATE".equals(v) || "date".equals(v)) {
                                value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                                values = values + "to_date('" + value + "' ,'yyyy-MM-dd hh24:mi:ss'),";
                                continue;
                            }
                            if ("DATETIME".equals(v) || "datetime".equals(v) || "timestamp".equals(v) || "TIMESTAMP".equals(v)) {
                                value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                                values = values + "to_date('" + value + "' ,'yyyy-MM-dd hh24:mi:ss'),";
                                continue;
                            }
                            if ("NUMBER".equals(v)) {
                                values = values + value + ",";
                                continue;
                            }
                            values = values + "'" + value + "',";
                            continue;
                        }
                        if ("dameng".equals(importDbType)) {
                            if ("DATE".equals(v) || "date".equals(v)) {
                                value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                                values = values + "to_date('" + value + "' ,'yyyy-MM-dd hh24:mi:ss'),";
                                continue;
                            }
                            if ("DATETIME".equals(v) || "datetime".equals(v) || "timestamp".equals(v) || "TIMESTAMP".equals(v)) {
                                value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                                values = values + "to_date('" + value + "' ,'yyyy-MM-dd hh24:mi:ss'),";
                                continue;
                            }
                            if ("NUMBER".equals(v) || "int".equals(v) || "INT".equals(v) || "float".equals(v) || "FLOAT".equals(v) || "double".equals(v) || "DOUBLE".equals(v)) {
                                values = values + value + ",";
                                continue;
                            }
                            values = values + "'" + value + "',";
                            continue;
                        }
                        if (!"mysql".equals(importDbType)) continue;
                        if ("DATE".equals(v) || "date".equals(v)) {
                            value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                            values = values + "'" + value + "',";
                            continue;
                        }
                        if ("DATETIME".equals(v) || "datetime".equals(v) || "timestamp".equals(v) || "TIMESTAMP".equals(v)) {
                            value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                            values = values + "'" + value + "',";
                            continue;
                        }
                        if ("NUMBER".equals(v) || "int".equals(v) || "INT".equals(v) || "float".equals(v) || "FLOAT".equals(v) || "double".equals(v) || "DOUBLE".equals(v)) {
                            values = values + value + ",";
                            continue;
                        }
                        values = values + "'" + value + "',";
                    }
                    if (importDbType.equals("oracle") || importDbType.equals("dameng")) {
                        tableName = tableName.toUpperCase();
                    }
                    sqlInsert = "insert into " + importSchema + "." + tableName + "(" + columns.substring(0, columns.length() - 1) + ") values (" + values.substring(0, values.length() - 1) + ");";
                    writer.println(sqlInsert);
                }
                writer.close();
                this.updateRealTimeText("\u7ed3\u675f\u5bfc\u51fa\u6570\u636e\uff1a-------------\n");
            }
            this.updateRealTimeText("\u5f00\u59cb\u5efa\u8868\uff1a-------------\n");
            if (importDbType.equals("oracle")) {
                sqlTableExist = "select * from all_tables where table_name = upper('" + tableName + "') and  owner = upper('" + exportUsername + "')";
            } else if (importDbType.equals("mysql")) {
                sqlTableExist = " SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema = '" + exportSchema + "' and table_name='" + tableName + "'; ";
            } else if (importDbType.equals("dameng")) {
                sqlTableExist = "SELECT OWNER, TABLE_NAME FROM ALL_TABLES WHERE OWNER = '" + exportUsername.toUpperCase() + "' and TABLE_NAME = '" + tableName.toUpperCase() + "';";
            }
            connection = DBTools.getConnection((String)importDriver, (String)importConnectionString, (String)importUsername, (String)importPassword);
            re = DBTools.executeQuery((Connection)connection, (String)sqlTableExist, null);
            if (re != null && re.size() > 0) {
                this.updateRealTimeText("\u8868\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5------------------\n");
                return;
            }
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);
            configuration.setDefaultEncoding("utf-8");
            configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Create.class, "/templates/"));
            Template template = configuration.getTemplate("createTable_" + importDbType + ".sql.ftl");
            String path = Tools.getPath() + File.separator + importDbType + File.separator;
            sqlPath = path + tableName + ".sql";
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tablespace", importTableSpace.toUpperCase());
            map.put("tableName", tableName.toUpperCase());
            map.put("username", importUsername.toUpperCase());
            map.put("schema", importSchema.toUpperCase());
            sql = "select * from " + tableName + " ;";
            List<Map<String, Object>> fields = SQLiteTools.executeQuery(sqliteConnect, sql, new Object[0]);
            for (Map map2 : fields) {
                Set keySet = map2.keySet();
                for (String key : keySet) {
                    if (importDbType.equals("oracle")) {
                        switch (map2.get(key).toString()) {
                            case "datetime": 
                            case "DATETIME": 
                            case "date": 
                            case "DATE": 
                            case "TIME": 
                            case "time": {
                                map2.put(key, "DATE");
                                break;
                            }
                            case "timestamp": 
                            case "TIMESTAMP": 
                            case "TIMESTAMP(6)": {
                                map2.put(key, "TIMESTAMP");
                                break;
                            }
                            case "char": 
                            case "CHAR": 
                            case "varchar": 
                            case "VARCHAR": 
                            case "varchar2": 
                            case "VARCHAR2": {
                                map2.put(key, "VARCHAR2");
                                break;
                            }
                            case "int": 
                            case "INT": {
                                map2.put(key, "NUMBER");
                                map2.put("dataLength", 9);
                                map2.put("dataPrecision", 0);
                                break;
                            }
                            case "double": 
                            case "DOUBLE": {
                                map2.put(key, "NUMBER");
                                map2.put("dataLength", 15);
                                map2.put("dataPrecision", 3);
                                break;
                            }
                            case "float": 
                            case "FLOAT": {
                                map2.put(key, "NUMBER");
                                map2.put("dataLength", 12);
                                map2.put("dataPrecision", 2);
                                break;
                            }
                            case "NUMBER": {
                                map2.put(key, "NUMBER");
                                map2.put("dataLength", map2.get("dataPrecision"));
                                map2.put("dataPrecision", map2.get("dataScale"));
                            }
                        }
                        continue;
                    }
                    if (importDbType.equals("dameng")) {
                        switch (map2.get(key).toString()) {
                            case "datetime": 
                            case "DATETIME": 
                            case "date": 
                            case "DATE": {
                                map2.put(key, "DATETIME");
                                break;
                            }
                            case "time": 
                            case "TIME": {
                                map2.put(key, "TIME");
                                break;
                            }
                            case "timestamp": 
                            case "TIMESTAMP": 
                            case "TIMESTAMP(6)": {
                                map2.put(key, "TIMESTAMP");
                                break;
                            }
                            case "char": 
                            case "CHAR": {
                                map2.put(key, "CHAR");
                                break;
                            }
                            case "varchar": 
                            case "VARCHAR": 
                            case "varchar2": 
                            case "VARCHAR2": {
                                map2.put(key, "VARCHAR");
                                break;
                            }
                            case "int": 
                            case "INT": {
                                map2.put(key, "INT");
                                break;
                            }
                            case "double": 
                            case "DOUBLE": {
                                map2.put(key, "DOUBLE");
                                break;
                            }
                            case "float": 
                            case "FLOAT": {
                                map2.put(key, "FLOAT");
                                break;
                            }
                            case "NUMBER": {
                                map2.put(key, "NUMBER");
                                map2.put("dataLength", map2.get("dataPrecision"));
                                map2.put("dataPrecision", map2.get("dataScale"));
                            }
                        }
                        continue;
                    }
                    if (!importDbType.equals("mysql")) continue;
                    switch (map2.get(key).toString()) {
                        case "datetime": 
                        case "DATETIME": {
                            map2.put(key, "datetime");
                            break;
                        }
                        case "date": 
                        case "DATE": {
                            map2.put(key, "date");
                            break;
                        }
                        case "time": 
                        case "TIME": {
                            map2.put(key, "time");
                            break;
                        }
                        case "timestamp": 
                        case "TIMESTAMP": 
                        case "TIMESTAMP(6)": {
                            map2.put(key, "timestamp");
                            break;
                        }
                        case "char": 
                        case "CHAR": {
                            map2.put(key, "char");
                            break;
                        }
                        case "varchar": 
                        case "VARCHAR": 
                        case "varchar2": 
                        case "VARCHAR2": {
                            map2.put(key, "varchar");
                            break;
                        }
                        case "int": 
                        case "INT": {
                            map2.put(key, "int");
                            break;
                        }
                        case "double": 
                        case "DOUBLE": {
                            map2.put(key, "double");
                            break;
                        }
                        case "float": 
                        case "FLOAT": {
                            map2.put(key, "float");
                            break;
                        }
                        case "NUMBER": {
                            map2.put(key, "double");
                            map2.put("dataLength", map2.get("dataPrecision"));
                            map2.put("dataPrecision", map2.get("dataScale"));
                        }
                    }
                }
            }
            map.put("fields", fields);
            FileWriter out = null;
            try {
                out = new FileWriter(new File(sqlPath));
                template.process(map, (Writer)out);
            }
            catch (Exception e) {
                this.updateRealTimeText("\u751f\u6210\u5efa\u8868\u8bed\u53e5\u5931\u8d25------------------\n");
                if (out == null) break block164;
                ((Writer)out).flush();
                ((Writer)out).close();
            }
        }
        try {
            connection = DBTools.getConnection((String)importDriver, (String)importConnectionString, (String)importUsername, (String)importPassword);
            ScriptRunner scriptRunner = new ScriptRunner(connection);
            scriptRunner.setStopOnError(true);
            scriptRunner.runScript((Reader)new FileReader(sqlPath));
        }
        catch (Exception ex) {
            this.updateRealTimeText("\u5efa\u8868\u5931\u8d25------------------\n");
            return;
        }
        finally {
            connection.close();
        }
        String dataSqlPath = SQLiteTools.getDataSqlPath(tableName + ".sql");
        InputStream inputStream = new FileInputStream(dataSqlPath);
        if (importDbType.equals("mysql")) {
            inputStream = Tools.replaceInInputStream(inputStream, "to_date", "str_to_date");
            inputStream = Tools.replaceInInputStream(inputStream, "yyyy-MM-dd hh24:mi:ss", "%Y-%m-%d %H:%i:%s");
        }
        connection = DBTools.getConnection((String)importDriver, (String)importConnectionString, (String)importUsername, (String)importPassword);
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        scriptRunner.setStopOnError(true);
        scriptRunner.runScript((Reader)new InputStreamReader(inputStream, "utf-8"));
        connection.close();
    }

    private void handleSave() {
        String tableName = this.tableNameField.getText();
        System.out.println("\u4fdd\u5b58\u7684\u8868\u540d: " + tableName);
    }

    private void openMaintainDatabaseWindow() {
        DbWindow dbWindow = new DbWindow();
        dbWindow.start(new Stage());
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    private void updateRealTimeText(String text) {
        this.realTimeTextArea.appendText(text + "\n");
    }
}

