/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator;

import cn.hutool.core.date.DateUtil;
import com.shinsoft.generator.tools.SQLiteTools;
import com.shinsoft.generator.tools.Tools;
import com.shinsoft.tools.DBTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class Export {
    public static void main(String[] args) {
        Properties prop = new Properties();
        Object input = null;
        Connection connection = null;
        PrintWriter writer = null;
        try {
            Map<String, String> mapConfig = Tools.getConfig();
            String username = mapConfig.get("username");
            String password = mapConfig.get("password");
            String driver = mapConfig.get("driver");
            String url = mapConfig.get("url");
            String tablespace = mapConfig.get("tablespace");
            String tableSchema = mapConfig.get("tableSchema");
            String dbType = mapConfig.get("dbType");
            String exportFilePath = Tools.getPath() + "data";
            System.out.println("\u5bfc\u51fa\u8def\u5f84exportFilePath\uff1a" + exportFilePath);
            File file = new File(exportFilePath);
            if (!file.exists()) {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939\uff1a" + exportFilePath);
                file.mkdirs();
            }
            System.out.println("\u5f00\u59cb\u5bfc\u51fa------");
            System.out.println("\u67e5\u8be2\u5bfc\u51fa\u8868");
            String querySQL = "SELECT * FROM table_export";
            List<Map<String, Object>> resultList = SQLiteTools.executeQuery(querySQL, new Object[0]);
            if (resultList.isEmpty()) {
                System.out.println("\u672a\u67e5\u5230\u9700\u8981\u5bfc\u51fa\u7684\u8868");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String tableName = "";
            String dataSql = "";
            String sqlCols = "";
            String sql = "";
            String sqlTableExist = "";
            for (Map<String, Object> row : resultList) {
                int i;
                tableName = row.get("table_name").toString();
                tableName = tableName.toUpperCase();
                System.out.println("tableName--------" + tableName);
                if (dbType.equals("oracle")) {
                    sqlTableExist = "select * from all_tables where table_name = upper('" + tableName + "') and  owner = upper('" + username + "')";
                } else if (dbType.equals("mysql")) {
                    sqlTableExist = " SELECT TABLE_NAME FROM information_schema.tables WHERE table_schema = '" + tableSchema + "'";
                } else if (dbType.equals("dameng")) {
                    sqlTableExist = "SELECT OWNER, TABLE_NAME FROM ALL_TABLES WHERE OWNER = '" + username.toUpperCase() + "';";
                }
                System.out.println("sqlTableExist--------" + sqlTableExist);
                connection = DBTools.getConnection((String)driver, (String)url, (String)username, (String)password);
                List re = DBTools.executeQuery((Connection)connection, (String)sqlTableExist, null);
                if (re == null || re.size() == 0) {
                    throw new Exception("\u672a\u627e\u5230\u8868");
                }
                connection = DBTools.getConnection((String)driver, (String)url, (String)username, (String)password);
                if (dbType.equals("oracle")) {
                    sqlCols = " SELECT A.COLUMN_NAME,B.comments,A.DATA_TYPE,a.DATA_LENGTH,a.DATA_PRECISION,a.DATA_SCALE  ,a.NULLABLE FROM   USER_TAB_COLUMNS A LEFT JOIN user_col_comments B ON A.TABLE_NAME=B.table_name AND A.COLUMN_NAME=B.column_name WHERE  A.TABLE_NAME = '" + tableName + "'  order by column_id ";
                } else if (dbType.equals("mysql")) {
                    sqlCols = " SELECT COLUMN_NAME,COLUMN_COMMENT as COMMENTS , DATA_TYPE, CHARACTER_MAXIMUM_LENGTH as DATA_LENGTH,  NUMERIC_PRECISION   ,NUMERIC_SCALE   ,IS_NULLABLE as NULLABLE  FROM information_schema.columns WHERE table_schema = '" + tableSchema + "' and table_name='" + tableName + "' order by ordinal_position;";
                } else if (dbType.equals("dameng")) {
                    sqlCols = "SELECT c.COLUMN_NAME,c.DATA_TYPE,c.DATA_LENGTH,c.DATA_PRECISION,c.DATA_SCALE,c.NULLABLE,c.DATA_DEFAULT,cc.COMMENTS FROM USER_TAB_COLUMNS c LEFT JOIN USER_COL_COMMENTS cc ON c.TABLE_NAME = cc.TABLE_NAME AND c.COLUMN_NAME = cc.COLUMN_NAME WHERE c.TABLE_NAME = '" + tableName + "'; ";
                }
                System.out.println(sqlCols);
                List cols = DBTools.executeQuery((Connection)connection, (String)sqlCols, null);
                if (cols == null || cols.size() == 0) {
                    throw new Exception("\u8868\u65e0\u5b57\u6bb5");
                }
                System.out.println("\u5220\u9664\u5df2\u5b58\u5728\u7684\u8868\u7ed3\u6784");
                sql = " DROP TABLE IF EXISTS " + tableName + " ;";
                SQLiteTools.executeInsert(sql, new Object[0]);
                System.out.println("\u521b\u5efa\u65b0\u7684\u8868\u7ed3\u6784");
                sql = " CREATE TABLE IF NOT EXISTS " + tableName + " (\n" + "    name TEXT  ,\n" + "    type TEXT  ,\n" + "    length INTEGER  ,\n" + "    precision INTEGER  ,\n" + "    scale INTEGER  ,\n" + "    comments TEXT  ,\n" + "    nullable TEXT  ,\n" + "    memo TEXT  \n" + ");  ";
                SQLiteTools.executeInsert(sql, new Object[0]);
                System.out.println("\u5f00\u59cb\u63d2\u5165\u5b57\u6bb5");
                for (i = 0; i < cols.size(); ++i) {
                    stringBuilder = new StringBuilder();
                    Map col = (Map)cols.get(i);
                    System.out.println("\u5f00\u59cb\u63d2\u5165\u5b57\u6bb5------" + col.get("COLUMN_NAME").toString().toUpperCase());
                    stringBuilder.append("insert into  " + tableName + " values (");
                    stringBuilder.append("'" + col.get("COLUMN_NAME").toString().toUpperCase() + "'").append(",");
                    stringBuilder.append("'" + col.get("DATA_TYPE").toString() + "'").append(",");
                    if (col.get("DATA_LENGTH") != null) {
                        stringBuilder.append(Integer.parseInt(col.get("DATA_LENGTH").toString())).append(",");
                    } else {
                        stringBuilder.append(0).append(",");
                    }
                    if (col.get("DATA_PRECISION") != null) {
                        stringBuilder.append(Integer.parseInt(col.get("DATA_PRECISION").toString())).append(",");
                    } else {
                        stringBuilder.append(0).append(",");
                    }
                    if (col.get("DATA_SCALE") != null) {
                        stringBuilder.append(Integer.parseInt(col.get("DATA_SCALE").toString())).append(",");
                    } else {
                        stringBuilder.append(0).append(",");
                    }
                    if (col.get("COMMENTS") != null) {
                        stringBuilder.append("'" + col.get("COMMENTS").toString() + "'").append(",");
                    } else {
                        stringBuilder.append("''").append(",");
                    }
                    if (col.get("NULLABLE") != null) {
                        stringBuilder.append("'" + col.get("NULLABLE").toString() + "'").append(",");
                    } else {
                        stringBuilder.append("'Y'").append(",");
                    }
                    stringBuilder.append("''");
                    stringBuilder.append(")");
                    sql = stringBuilder.toString();
                    System.out.println(sql);
                    int successCount = SQLiteTools.executeInsert(sql, new Object[0]);
                    System.out.println("\u6210\u529f\u6761\u6570:" + successCount);
                }
                dataSql = row.get("data_sql") == null ? "" : row.get("data_sql").toString();
                System.out.println("dataSql--------" + dataSql);
                if (StringUtils.isEmpty((CharSequence)dataSql)) {
                    System.out.println("\u65e0sql\u8bed\u53e5\uff0c\u4e0d\u5bfc\u51fa\u6570\u636e");
                    continue;
                }
                System.out.println("\u5f00\u59cb\u5bfc\u51fa\u6570\u636e");
                System.out.println("\u5bfc\u51fa\u6570\u636esql======" + dataSql);
                connection = DBTools.getConnection((String)driver, (String)url, (String)username, (String)password);
                re = DBTools.executeQuery((Connection)connection, (String)dataSql, null);
                writer = new PrintWriter(exportFilePath + File.separator + tableName + ".sql", "utf-8");
                for (i = 0; i < re.size(); ++i) {
                    Map map = (Map)re.get(i);
                    String sqlInsert = "";
                    String columns = "";
                    String values = "";
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        String finalKey = key;
                        Object dataType = cols.stream().filter(m -> m.get("COLUMN_NAME").toString().equals(finalKey)).findFirst().get().get("DATA_TYPE");
                        if (value == null) continue;
                        columns = columns + key + ",";
                        if ("DATE".equals(dataType)) {
                            value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                            values = values + "to_date('" + value + "' ,'yyyy-MM-dd hh24:mi:ss'),";
                            continue;
                        }
                        if ("DATETIME".equals(dataType) || "datetime".equals(dataType)) {
                            value = DateUtil.format((Date)DateUtil.parse((CharSequence)value.toString()), (String)"yyyy-MM-dd HH:mm:ss");
                            values = values + "'" + value + "',";
                            continue;
                        }
                        if ("NUMBER".equals(dataType)) {
                            values = values + value + ",";
                            continue;
                        }
                        values = values + "'" + value + "',";
                    }
                    sqlInsert = "insert into " + tableSchema + "." + tableName + "(" + columns.substring(0, columns.length() - 1) + ") values (" + values.substring(0, values.length() - 1) + ");";
                    writer.println(sqlInsert);
                }
                writer.close();
                System.out.println("\u7ed3\u675f\u5bfc\u51fa\u6570\u636e\uff1a----------------");
            }
            System.out.println("\u6570\u636e\u5bfc\u51fa\u8def\u5f84exportFilePath\uff1a" + exportFilePath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFileByLines(String filePath) throws Exception {
        StringBuffer str = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            String tempString = null;
            int line = 1;
            while ((tempString = reader.readLine()) != null) {
                str = str.append(" " + tempString);
                ++line;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return str.toString();
    }
}

