/*
 * Decompiled with CFR 0.152.
 */
package com.shinsoft.generator;

import com.shinsoft.generator.tools.SQLiteTools;
import com.shinsoft.generator.tools.Tools;
import com.shinsoft.tools.DBTools;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.springframework.util.CollectionUtils;

public class Create {
    public static void main(String[] args) {
        Connection connection = null;
        try {
            Map<String, String> mapConfig = Tools.getConfig();
            String username = mapConfig.get("username");
            String password = mapConfig.get("password");
            String driver = mapConfig.get("driver");
            String url = mapConfig.get("url");
            String tablespace = mapConfig.get("tablespace");
            String tableSchema = mapConfig.get("tableSchema");
            String dbType = mapConfig.get("dbType");
            String path = Tools.getPath() + File.separator + dbType + File.separator;
            System.out.println(path);
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            Configuration configuration = new Configuration(Configuration.getVersion());
            configuration.setDefaultEncoding("utf-8");
            configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Create.class, "/templates/" + dbType));
            String sqlTableExist = "";
            String querySQL = "SELECT * FROM table_create";
            List<Map<String, Object>> resultList = SQLiteTools.executeQuery(querySQL, new Object[0]);
            if (resultList.isEmpty()) {
                System.out.println("No users found matching the criteria.");
            } else {
                System.out.println("Query results:");
                for (Map<String, Object> row : resultList) {
                    String tableName = row.get("table_name").toString();
                    tableName = tableName.trim().toUpperCase();
                    connection = DBTools.getConnection((String)driver, (String)url, (String)username, (String)password);
                    if (dbType.equals("oracle")) {
                        sqlTableExist = "select * from all_tables where table_name = upper('" + tableName + "') and  owner = upper('" + username + "')";
                    } else if (dbType.equals("mysql")) {
                        sqlTableExist = "select table_name from information_schema.tables where table_name='" + tableName + "' and table_schema='" + tableSchema + "'";
                    } else if (dbType.equals("dameng")) {
                        sqlTableExist = "SELECT TABLE_NAME FROM USER_TABLES where TABLE_NAME='" + tableName + "' ;";
                    }
                    List re = DBTools.executeQuery((Connection)connection, (String)sqlTableExist, null);
                    if (!CollectionUtils.isEmpty((Collection)re)) continue;
                    Template template = configuration.getTemplate("create.sql.ftl");
                    String sqlPath = path + tableName + ".sql";
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("tableSpace", tablespace.toUpperCase());
                    map.put("tableName", tableName.toUpperCase());
                    map.put("username", username.toUpperCase());
                    String sql = "select * from " + tableName + " ;";
                    List<Map<String, Object>> fields = SQLiteTools.executeQuery(sql, new Object[0]);
                    map.put("fields", fields);
                    FileWriter out = new FileWriter(new File(sqlPath));
                    template.process(map, (Writer)out);
                    ((Writer)out).flush();
                    ((Writer)out).close();
                    connection = DBTools.getConnection((String)driver, (String)url, (String)username, (String)password);
                    ScriptRunner runner = new ScriptRunner(connection);
                    runner.setStopOnError(true);
                    runner.runScript((Reader)new FileReader(sqlPath));
                    connection.close();
                }
                System.out.println("\u8868\u521b\u5efa\u5b8c\u6bd5");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

